/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitCSSKeyframesRule.h"

#include "CSSRuleList.h"
#include "ExceptionCode.h"
#include "JSCSSRuleList.h"
#include "JSDOMBinding.h"
#include "JSWebKitCSSKeyframeRule.h"
#include "KURL.h"
#include "WebKitCSSKeyframeRule.h"
#include "WebKitCSSKeyframesRule.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebKitCSSKeyframesRuleTableValues[] =
{
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSKeyframesRuleName), (intptr_t)setJSWebKitCSSKeyframesRuleName, NoIntrinsic },
    { "cssRules", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSKeyframesRuleCssRules), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitCSSKeyframesRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSKeyframesRuleTable = { 9, 7, JSWebKitCSSKeyframesRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebKitCSSKeyframesRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSKeyframesRuleConstructorTable = { 1, 0, JSWebKitCSSKeyframesRuleConstructorTableValues, 0 };
const ClassInfo JSWebKitCSSKeyframesRuleConstructor::s_info = { "WebKitCSSKeyframesRuleConstructor", &Base::s_info, &JSWebKitCSSKeyframesRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSWebKitCSSKeyframesRuleConstructor) };

JSWebKitCSSKeyframesRuleConstructor::JSWebKitCSSKeyframesRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitCSSKeyframesRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitCSSKeyframesRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitCSSKeyframesRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitCSSKeyframesRuleConstructor, JSDOMWrapper>(exec, &JSWebKitCSSKeyframesRuleConstructorTable, jsCast<JSWebKitCSSKeyframesRuleConstructor*>(cell), propertyName, slot);
}

bool JSWebKitCSSKeyframesRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitCSSKeyframesRuleConstructor, JSDOMWrapper>(exec, &JSWebKitCSSKeyframesRuleConstructorTable, jsCast<JSWebKitCSSKeyframesRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitCSSKeyframesRulePrototypeTableValues[] =
{
    { "insertRule", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSKeyframesRulePrototypeFunctionInsertRule), (intptr_t)1, NoIntrinsic },
    { "deleteRule", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSKeyframesRulePrototypeFunctionDeleteRule), (intptr_t)1, NoIntrinsic },
    { "findRule", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsWebKitCSSKeyframesRulePrototypeFunctionFindRule), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebKitCSSKeyframesRulePrototypeTable = { 8, 7, JSWebKitCSSKeyframesRulePrototypeTableValues, 0 };
const ClassInfo JSWebKitCSSKeyframesRulePrototype::s_info = { "WebKitCSSKeyframesRulePrototype", &Base::s_info, &JSWebKitCSSKeyframesRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSWebKitCSSKeyframesRulePrototype) };

JSObject* JSWebKitCSSKeyframesRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitCSSKeyframesRule>(exec, globalObject);
}

bool JSWebKitCSSKeyframesRulePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitCSSKeyframesRulePrototype* thisObject = jsCast<JSWebKitCSSKeyframesRulePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitCSSKeyframesRulePrototypeTable, thisObject, propertyName, slot);
}

bool JSWebKitCSSKeyframesRulePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitCSSKeyframesRulePrototype* thisObject = jsCast<JSWebKitCSSKeyframesRulePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebKitCSSKeyframesRulePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSWebKitCSSKeyframesRule::s_info = { "WebKitCSSKeyframesRule", &Base::s_info, &JSWebKitCSSKeyframesRuleTable, 0 , CREATE_METHOD_TABLE(JSWebKitCSSKeyframesRule) };

JSWebKitCSSKeyframesRule::JSWebKitCSSKeyframesRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitCSSKeyframesRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSWebKitCSSKeyframesRule::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitCSSKeyframesRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitCSSKeyframesRulePrototype::create(exec->globalData(), globalObject, JSWebKitCSSKeyframesRulePrototype::createStructure(exec->globalData(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSWebKitCSSKeyframesRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebKitCSSKeyframesRule* thisObject = jsCast<JSWebKitCSSKeyframesRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSWebKitCSSKeyframesRule>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<WebKitCSSKeyframesRule*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSWebKitCSSKeyframesRule, Base>(exec, &JSWebKitCSSKeyframesRuleTable, thisObject, propertyName, slot);
}

bool JSWebKitCSSKeyframesRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebKitCSSKeyframesRule* thisObject = jsCast<JSWebKitCSSKeyframesRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSWebKitCSSKeyframesRuleTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<WebKitCSSKeyframesRule*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSWebKitCSSKeyframesRule, Base>(exec, &JSWebKitCSSKeyframesRuleTable, thisObject, propertyName, descriptor);
}

bool JSWebKitCSSKeyframesRule::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSWebKitCSSKeyframesRule* thisObject = jsCast<JSWebKitCSSKeyframesRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<WebKitCSSKeyframesRule*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsWebKitCSSKeyframesRuleName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSKeyframesRule* castedThis = jsCast<JSWebKitCSSKeyframesRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSKeyframesRule* impl = static_cast<WebKitCSSKeyframesRule*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->name());
    return result;
}


JSValue jsWebKitCSSKeyframesRuleCssRules(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSKeyframesRule* castedThis = jsCast<JSWebKitCSSKeyframesRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitCSSKeyframesRule* impl = static_cast<WebKitCSSKeyframesRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->cssRules()));
    return result;
}


JSValue jsWebKitCSSKeyframesRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebKitCSSKeyframesRule* domObject = jsCast<JSWebKitCSSKeyframesRule*>(asObject(slotBase));
    return JSWebKitCSSKeyframesRule::getConstructor(exec, domObject->globalObject());
}

void JSWebKitCSSKeyframesRule::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSWebKitCSSKeyframesRule* thisObject = jsCast<JSWebKitCSSKeyframesRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSWebKitCSSKeyframesRule, Base>(exec, propertyName, value, &JSWebKitCSSKeyframesRuleTable, thisObject, slot);
}

void setJSWebKitCSSKeyframesRuleName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSWebKitCSSKeyframesRule* castedThis = jsCast<JSWebKitCSSKeyframesRule*>(thisObject);
    WebKitCSSKeyframesRule* impl = static_cast<WebKitCSSKeyframesRule*>(castedThis->impl());
    impl->setName(valueToStringWithNullCheck(exec, value));
}


void JSWebKitCSSKeyframesRule::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSWebKitCSSKeyframesRule* thisObject = jsCast<JSWebKitCSSKeyframesRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<WebKitCSSKeyframesRule*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSWebKitCSSKeyframesRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitCSSKeyframesRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSKeyframesRulePrototypeFunctionInsertRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSKeyframesRule::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSKeyframesRule* castedThis = jsCast<JSWebKitCSSKeyframesRule*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitCSSKeyframesRule::s_info);
    WebKitCSSKeyframesRule* impl = static_cast<WebKitCSSKeyframesRule*>(castedThis->impl());
    const String& rule(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->insertRule(rule);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSKeyframesRulePrototypeFunctionDeleteRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSKeyframesRule::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSKeyframesRule* castedThis = jsCast<JSWebKitCSSKeyframesRule*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitCSSKeyframesRule::s_info);
    WebKitCSSKeyframesRule* impl = static_cast<WebKitCSSKeyframesRule*>(castedThis->impl());
    const String& key(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->deleteRule(key);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitCSSKeyframesRulePrototypeFunctionFindRule(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitCSSKeyframesRule::s_info))
        return throwVMTypeError(exec);
    JSWebKitCSSKeyframesRule* castedThis = jsCast<JSWebKitCSSKeyframesRule*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitCSSKeyframesRule::s_info);
    WebKitCSSKeyframesRule* impl = static_cast<WebKitCSSKeyframesRule*>(castedThis->impl());
    const String& key(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->findRule(key)));
    return JSValue::encode(result);
}


JSValue JSWebKitCSSKeyframesRule::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSWebKitCSSKeyframesRule* thisObj = jsCast<JSWebKitCSSKeyframesRule*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<WebKitCSSKeyframesRule*>(thisObj->impl())->item(index));
}


}
