/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHistory.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHistoryPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_HISTORY_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_HISTORY, WebKitDOMHistoryPrivate)

typedef struct _WebKitDOMHistoryPrivate {
    RefPtr<WebCore::History> coreObject;
} WebKitDOMHistoryPrivate;

namespace WebKit {

WebKitDOMHistory* kit(WebCore::History* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_HISTORY(ret);

    return wrapHistory(obj);
}

WebCore::History* core(WebKitDOMHistory* request)
{
    return request ? static_cast<WebCore::History*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHistory* wrapHistory(WebCore::History* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HISTORY(g_object_new(WEBKIT_TYPE_DOM_HISTORY, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHistory, webkit_dom_history, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_history_finalize(GObject* object)
{
    WebKitDOMHistoryPrivate* priv = WEBKIT_DOM_HISTORY_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMHistoryPrivate();
    G_OBJECT_CLASS(webkit_dom_history_parent_class)->finalize(object);
}

static void webkit_dom_history_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHistory* self = WEBKIT_DOM_HISTORY(object);
    WebCore::History* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_LENGTH: {
        g_value_set_ulong(value, coreSelf->length());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_history_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_history_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMHistoryPrivate* priv = WEBKIT_DOM_HISTORY_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::History*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_history_class_init(WebKitDOMHistoryClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMHistoryPrivate));
    gobjectClass->constructor = webkit_dom_history_constructor;
    gobjectClass->finalize = webkit_dom_history_finalize;
    gobjectClass->get_property = webkit_dom_history_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "history_length", /* short description */
                                                           "read-only  gulong History.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_history_init(WebKitDOMHistory* request)
{
    WebKitDOMHistoryPrivate* priv = WEBKIT_DOM_HISTORY_GET_PRIVATE(request);
    new (priv) WebKitDOMHistoryPrivate();
}

void
webkit_dom_history_back(WebKitDOMHistory* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HISTORY(self));
    WebCore::History* item = WebKit::core(self);
    item->back();
}

void
webkit_dom_history_forward(WebKitDOMHistory* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HISTORY(self));
    WebCore::History* item = WebKit::core(self);
    item->forward();
}

void
webkit_dom_history_go(WebKitDOMHistory* self, glong distance)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HISTORY(self));
    WebCore::History* item = WebKit::core(self);
    item->go(distance);
}

gulong
webkit_dom_history_get_length(WebKitDOMHistory* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HISTORY(self), 0);
    WebCore::History* item = WebKit::core(self);
    gulong result = item->length();
    return result;
}

