/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMTextTrackList.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTextTrackListPrivate.h"
#include "WebKitDOMTextTrackPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TEXT_TRACK_LIST_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_TEXT_TRACK_LIST, WebKitDOMTextTrackListPrivate)

typedef struct _WebKitDOMTextTrackListPrivate {
#if ENABLE(VIDEO_TRACK)
    RefPtr<WebCore::TextTrackList> coreObject;
#endif // ENABLE(VIDEO_TRACK)
} WebKitDOMTextTrackListPrivate;

#if ENABLE(VIDEO_TRACK)

namespace WebKit {

WebKitDOMTextTrackList* kit(WebCore::TextTrackList* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TEXT_TRACK_LIST(ret);

    return wrapTextTrackList(obj);
}

WebCore::TextTrackList* core(WebKitDOMTextTrackList* request)
{
    return request ? static_cast<WebCore::TextTrackList*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTextTrackList* wrapTextTrackList(WebCore::TextTrackList* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEXT_TRACK_LIST(g_object_new(WEBKIT_TYPE_DOM_TEXT_TRACK_LIST, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(VIDEO_TRACK)

static void webkit_dom_text_track_list_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::TextTrackList* coreTarget = static_cast<WebCore::TextTrackList*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif // ENABLE(VIDEO_TRACK)
}

static gboolean webkit_dom_text_track_list_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::TextTrackList* coreTarget = static_cast<WebCore::TextTrackList*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return false;
#endif // ENABLE(VIDEO_TRACK)
}

static gboolean webkit_dom_text_track_list_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::TextTrackList* coreTarget = static_cast<WebCore::TextTrackList*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return false;
#endif // ENABLE(VIDEO_TRACK)
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_text_track_list_dispatch_event;
    iface->add_event_listener = webkit_dom_text_track_list_add_event_listener;
    iface->remove_event_listener = webkit_dom_text_track_list_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMTextTrackList, webkit_dom_text_track_list, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_LENGTH,
};

static void webkit_dom_text_track_list_finalize(GObject* object)
{
    WebKitDOMTextTrackListPrivate* priv = WEBKIT_DOM_TEXT_TRACK_LIST_GET_PRIVATE(object);
#if ENABLE(VIDEO_TRACK)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(VIDEO_TRACK)
    priv->~WebKitDOMTextTrackListPrivate();
    G_OBJECT_CLASS(webkit_dom_text_track_list_parent_class)->finalize(object);
}

static void webkit_dom_text_track_list_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrackList* self = WEBKIT_DOM_TEXT_TRACK_LIST(object);
    WebCore::TextTrackList* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO_TRACK)
    switch (propertyId) {
    case PROP_LENGTH: {
#if ENABLE(VIDEO_TRACK)
        g_value_set_ulong(value, coreSelf->length());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
#endif /* ENABLE(VIDEO_TRACK) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_text_track_list_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_text_track_list_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(VIDEO_TRACK)
    WebKitDOMTextTrackListPrivate* priv = WEBKIT_DOM_TEXT_TRACK_LIST_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TextTrackList*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(VIDEO_TRACK)
    return object;
}

static void webkit_dom_text_track_list_class_init(WebKitDOMTextTrackListClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTextTrackListPrivate));
    gobjectClass->constructor = webkit_dom_text_track_list_constructor;
    gobjectClass->finalize = webkit_dom_text_track_list_finalize;
    gobjectClass->get_property = webkit_dom_text_track_list_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "text_track_list_length", /* short description */
                                                           "read-only  gulong TextTrackList.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_text_track_list_init(WebKitDOMTextTrackList* request)
{
    WebKitDOMTextTrackListPrivate* priv = WEBKIT_DOM_TEXT_TRACK_LIST_GET_PRIVATE(request);
    new (priv) WebKitDOMTextTrackListPrivate();
}

WebKitDOMTextTrack*
webkit_dom_text_track_list_item(WebKitDOMTextTrackList* self, gulong index)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_LIST(self), 0);
    WebCore::TextTrackList* item = WebKit::core(self);
    RefPtr<WebCore::TextTrack> gobjectResult = WTF::getPtr(item->item(index));
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return 0;
#endif /* ENABLE(VIDEO_TRACK) */
}

gboolean
webkit_dom_text_track_list_dispatch_event(WebKitDOMTextTrackList* self, WebKitDOMEvent* evt, GError** error)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_LIST(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(evt), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::TextTrackList* item = WebKit::core(self);
    WebCore::Event* convertedEvt = WebKit::core(evt);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->dispatchEvent(convertedEvt, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gboolean>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

gulong
webkit_dom_text_track_list_get_length(WebKitDOMTextTrackList* self)
{
#if ENABLE(VIDEO_TRACK)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT_TRACK_LIST(self), 0);
    WebCore::TextTrackList* item = WebKit::core(self);
    gulong result = item->length();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video Track")
    return static_cast<gulong>(0);
#endif /* ENABLE(VIDEO_TRACK) */
}

