/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMXPathNSResolver.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMXPathNSResolverPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_XPATH_NS_RESOLVER_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_XPATH_NS_RESOLVER, WebKitDOMXPathNSResolverPrivate)

typedef struct _WebKitDOMXPathNSResolverPrivate {
    RefPtr<WebCore::XPathNSResolver> coreObject;
} WebKitDOMXPathNSResolverPrivate;

namespace WebKit {

WebKitDOMXPathNSResolver* kit(WebCore::XPathNSResolver* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_XPATH_NS_RESOLVER(ret);

    return wrapXPathNSResolver(obj);
}

WebCore::XPathNSResolver* core(WebKitDOMXPathNSResolver* request)
{
    return request ? static_cast<WebCore::XPathNSResolver*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMXPathNSResolver* wrapXPathNSResolver(WebCore::XPathNSResolver* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_XPATH_NS_RESOLVER(g_object_new(WEBKIT_TYPE_DOM_XPATH_NS_RESOLVER, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMXPathNSResolver, webkit_dom_xpath_ns_resolver, WEBKIT_TYPE_DOM_OBJECT)

static void webkit_dom_xpath_ns_resolver_finalize(GObject* object)
{
    WebKitDOMXPathNSResolverPrivate* priv = WEBKIT_DOM_XPATH_NS_RESOLVER_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMXPathNSResolverPrivate();
    G_OBJECT_CLASS(webkit_dom_xpath_ns_resolver_parent_class)->finalize(object);
}

static GObject* webkit_dom_xpath_ns_resolver_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_xpath_ns_resolver_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMXPathNSResolverPrivate* priv = WEBKIT_DOM_XPATH_NS_RESOLVER_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::XPathNSResolver*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_xpath_ns_resolver_class_init(WebKitDOMXPathNSResolverClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMXPathNSResolverPrivate));
    gobjectClass->constructor = webkit_dom_xpath_ns_resolver_constructor;
    gobjectClass->finalize = webkit_dom_xpath_ns_resolver_finalize;
}

static void webkit_dom_xpath_ns_resolver_init(WebKitDOMXPathNSResolver* request)
{
    WebKitDOMXPathNSResolverPrivate* priv = WEBKIT_DOM_XPATH_NS_RESOLVER_GET_PRIVATE(request);
    new (priv) WebKitDOMXPathNSResolverPrivate();
}

gchar*
webkit_dom_xpath_ns_resolver_lookup_namespace_uri(WebKitDOMXPathNSResolver* self, const gchar* prefix)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_XPATH_NS_RESOLVER(self), 0);
    g_return_val_if_fail(prefix, 0);
    WebCore::XPathNSResolver* item = WebKit::core(self);
    WTF::String convertedPrefix = WTF::String::fromUTF8(prefix);
    gchar* result = convertToUTF8String(item->lookupNamespaceURI(convertedPrefix));
    return result;
}

