/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLLIElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLLIElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLLIElement* kit(WebCore::HTMLLIElement* obj)
{
    return WEBKIT_DOM_HTMLLI_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLLIElement* core(WebKitDOMHTMLLIElement* request)
{
    return request ? static_cast<WebCore::HTMLLIElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLLIElement* wrapHTMLLIElement(WebCore::HTMLLIElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTMLLI_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTMLLI_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLLIElement, webkit_dom_htmlli_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_TYPE,
    PROP_VALUE,
};

static void webkit_dom_htmlli_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLLIElement* self = WEBKIT_DOM_HTMLLI_ELEMENT(object);
    WebCore::HTMLLIElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VALUE: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::valueAttr, (g_value_get_long(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmlli_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLLIElement* self = WEBKIT_DOM_HTMLLI_ELEMENT(object);
    WebCore::HTMLLIElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    case PROP_VALUE: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::valueAttr));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmlli_element_class_init(WebKitDOMHTMLLIElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_htmlli_element_set_property;
    gobjectClass->get_property = webkit_dom_htmlli_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "htmlli_element_type", /* short description */
                                                           "read-write  gchar* HTMLLIElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_long("value", /* name */
                                                           "htmlli_element_value", /* short description */
                                                           "read-write  glong HTMLLIElement.value", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_htmlli_element_init(WebKitDOMHTMLLIElement* request)
{
}

glong
webkit_dom_htmlli_element_get_value(WebKitDOMHTMLLIElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLLI_ELEMENT(self), 0);
    WebCore::HTMLLIElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::valueAttr);
    return result;
}

void
webkit_dom_htmlli_element_set_value(WebKitDOMHTMLLIElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLLI_ELEMENT(self));
    WebCore::HTMLLIElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::valueAttr, value);
}

