/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLOListElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLOListElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLOListElement* kit(WebCore::HTMLOListElement* obj)
{
    return WEBKIT_DOM_HTMLO_LIST_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLOListElement* core(WebKitDOMHTMLOListElement* request)
{
    return request ? static_cast<WebCore::HTMLOListElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLOListElement* wrapHTMLOListElement(WebCore::HTMLOListElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTMLO_LIST_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTMLO_LIST_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLOListElement, webkit_dom_htmlo_list_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_COMPACT,
    PROP_START,
    PROP_REVERSED,
    PROP_TYPE,
};

static void webkit_dom_htmlo_list_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLOListElement* self = WEBKIT_DOM_HTMLO_LIST_ELEMENT(object);
    WebCore::HTMLOListElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_COMPACT: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::compactAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_START: {
        coreSelf->setStart((g_value_get_long(value)));
        break;
    }
    case PROP_REVERSED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::reversedAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmlo_list_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLOListElement* self = WEBKIT_DOM_HTMLO_LIST_ELEMENT(object);
    WebCore::HTMLOListElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_COMPACT: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::compactAttr));
        break;
    }
    case PROP_START: {
        g_value_set_long(value, coreSelf->start());
        break;
    }
    case PROP_REVERSED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::reversedAttr));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmlo_list_element_class_init(WebKitDOMHTMLOListElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_htmlo_list_element_set_property;
    gobjectClass->get_property = webkit_dom_htmlo_list_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_COMPACT,
                                    g_param_spec_boolean("compact", /* name */
                                                           "htmlo_list_element_compact", /* short description */
                                                           "read-write  gboolean HTMLOListElement.compact", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_START,
                                    g_param_spec_long("start", /* name */
                                                           "htmlo_list_element_start", /* short description */
                                                           "read-write  glong HTMLOListElement.start", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REVERSED,
                                    g_param_spec_boolean("reversed", /* name */
                                                           "htmlo_list_element_reversed", /* short description */
                                                           "read-write  gboolean HTMLOListElement.reversed", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "htmlo_list_element_type", /* short description */
                                                           "read-write  gchar* HTMLOListElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_htmlo_list_element_init(WebKitDOMHTMLOListElement* request)
{
}

gboolean
webkit_dom_htmlo_list_element_get_compact(WebKitDOMHTMLOListElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLO_LIST_ELEMENT(self), FALSE);
    WebCore::HTMLOListElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::compactAttr);
    return result;
}

void
webkit_dom_htmlo_list_element_set_compact(WebKitDOMHTMLOListElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLO_LIST_ELEMENT(self));
    WebCore::HTMLOListElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::compactAttr, value);
}

glong
webkit_dom_htmlo_list_element_get_start(WebKitDOMHTMLOListElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLO_LIST_ELEMENT(self), 0);
    WebCore::HTMLOListElement* item = WebKit::core(self);
    glong result = item->start();
    return result;
}

void
webkit_dom_htmlo_list_element_set_start(WebKitDOMHTMLOListElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLO_LIST_ELEMENT(self));
    WebCore::HTMLOListElement* item = WebKit::core(self);
    item->setStart(value);
}

gboolean
webkit_dom_htmlo_list_element_get_reversed(WebKitDOMHTMLOListElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLO_LIST_ELEMENT(self), FALSE);
    WebCore::HTMLOListElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::reversedAttr);
    return result;
}

void
webkit_dom_htmlo_list_element_set_reversed(WebKitDOMHTMLOListElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLO_LIST_ELEMENT(self));
    WebCore::HTMLOListElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::reversedAttr, value);
}

