/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLOptGroupElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLOptGroupElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLOptGroupElement* kit(WebCore::HTMLOptGroupElement* obj)
{
    return WEBKIT_DOM_HTML_OPT_GROUP_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLOptGroupElement* core(WebKitDOMHTMLOptGroupElement* request)
{
    return request ? static_cast<WebCore::HTMLOptGroupElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLOptGroupElement* wrapHTMLOptGroupElement(WebCore::HTMLOptGroupElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_OPT_GROUP_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_OPT_GROUP_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLOptGroupElement, webkit_dom_html_opt_group_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_DISABLED,
    PROP_LABEL,
};

static void webkit_dom_html_opt_group_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLOptGroupElement* self = WEBKIT_DOM_HTML_OPT_GROUP_ELEMENT(object);
    WebCore::HTMLOptGroupElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_LABEL: {
        coreSelf->setAttribute(WebCore::HTMLNames::labelAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_opt_group_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLOptGroupElement* self = WEBKIT_DOM_HTML_OPT_GROUP_ELEMENT(object);
    WebCore::HTMLOptGroupElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_LABEL: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::labelAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_opt_group_element_class_init(WebKitDOMHTMLOptGroupElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_opt_group_element_set_property;
    gobjectClass->get_property = webkit_dom_html_opt_group_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_opt_group_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLOptGroupElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LABEL,
                                    g_param_spec_string("label", /* name */
                                                           "html_opt_group_element_label", /* short description */
                                                           "read-write  gchar* HTMLOptGroupElement.label", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_opt_group_element_init(WebKitDOMHTMLOptGroupElement* request)
{
}

gboolean
webkit_dom_html_opt_group_element_get_disabled(WebKitDOMHTMLOptGroupElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPT_GROUP_ELEMENT(self), FALSE);
    WebCore::HTMLOptGroupElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_opt_group_element_set_disabled(WebKitDOMHTMLOptGroupElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OPT_GROUP_ELEMENT(self));
    WebCore::HTMLOptGroupElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

gchar*
webkit_dom_html_opt_group_element_get_label(WebKitDOMHTMLOptGroupElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPT_GROUP_ELEMENT(self), 0);
    WebCore::HTMLOptGroupElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::labelAttr));
    return result;
}

void
webkit_dom_html_opt_group_element_set_label(WebKitDOMHTMLOptGroupElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OPT_GROUP_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLOptGroupElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::labelAttr, convertedValue);
}

