/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMPerformance.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMMemoryInfoPrivate.h"
#include "WebKitDOMPerformanceNavigationPrivate.h"
#include "WebKitDOMPerformancePrivate.h"
#include "WebKitDOMPerformanceTimingPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_PERFORMANCE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_PERFORMANCE, WebKitDOMPerformancePrivate)

typedef struct _WebKitDOMPerformancePrivate {
#if ENABLE(WEB_TIMING)
    RefPtr<WebCore::Performance> coreObject;
#endif // ENABLE(WEB_TIMING)
} WebKitDOMPerformancePrivate;

#if ENABLE(WEB_TIMING)

namespace WebKit {

WebKitDOMPerformance* kit(WebCore::Performance* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_PERFORMANCE(ret);

    return wrapPerformance(obj);
}

WebCore::Performance* core(WebKitDOMPerformance* request)
{
    return request ? static_cast<WebCore::Performance*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMPerformance* wrapPerformance(WebCore::Performance* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_PERFORMANCE(g_object_new(WEBKIT_TYPE_DOM_PERFORMANCE, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(WEB_TIMING)

static void webkit_dom_performance_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
#if ENABLE(WEB_TIMING)
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::Performance* coreTarget = static_cast<WebCore::Performance*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif // ENABLE(WEB_TIMING)
}

static gboolean webkit_dom_performance_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
#if ENABLE(WEB_TIMING)
    WebCore::Performance* coreTarget = static_cast<WebCore::Performance*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return false;
#endif // ENABLE(WEB_TIMING)
}

static gboolean webkit_dom_performance_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
#if ENABLE(WEB_TIMING)
    WebCore::Performance* coreTarget = static_cast<WebCore::Performance*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return false;
#endif // ENABLE(WEB_TIMING)
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_performance_dispatch_event;
    iface->add_event_listener = webkit_dom_performance_add_event_listener;
    iface->remove_event_listener = webkit_dom_performance_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMPerformance, webkit_dom_performance, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_NAVIGATION,
    PROP_TIMING,
    PROP_MEMORY,
};

static void webkit_dom_performance_finalize(GObject* object)
{
    WebKitDOMPerformancePrivate* priv = WEBKIT_DOM_PERFORMANCE_GET_PRIVATE(object);
#if ENABLE(WEB_TIMING)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(WEB_TIMING)
    priv->~WebKitDOMPerformancePrivate();
    G_OBJECT_CLASS(webkit_dom_performance_parent_class)->finalize(object);
}

static void webkit_dom_performance_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(WEB_TIMING)
    WebKitDOMPerformance* self = WEBKIT_DOM_PERFORMANCE(object);
    WebCore::Performance* coreSelf = WebKit::core(self);
#endif // ENABLE(WEB_TIMING)
    switch (propertyId) {
    case PROP_NAVIGATION: {
#if ENABLE(WEB_TIMING)
        RefPtr<WebCore::PerformanceNavigation> ptr = coreSelf->navigation();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_TIMING: {
#if ENABLE(WEB_TIMING)
        RefPtr<WebCore::PerformanceTiming> ptr = coreSelf->timing();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    case PROP_MEMORY: {
#if ENABLE(WEB_TIMING)
        RefPtr<WebCore::MemoryInfo> ptr = coreSelf->memory();
        g_value_set_object(value, WebKit::kit(ptr.get()));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
#endif /* ENABLE(WEB_TIMING) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_performance_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_performance_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(WEB_TIMING)
    WebKitDOMPerformancePrivate* priv = WEBKIT_DOM_PERFORMANCE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Performance*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(WEB_TIMING)
    return object;
}

static void webkit_dom_performance_class_init(WebKitDOMPerformanceClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMPerformancePrivate));
    gobjectClass->constructor = webkit_dom_performance_constructor;
    gobjectClass->finalize = webkit_dom_performance_finalize;
    gobjectClass->get_property = webkit_dom_performance_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NAVIGATION,
                                    g_param_spec_object("navigation", /* name */
                                                           "performance_navigation", /* short description */
                                                           "read-only  WebKitDOMPerformanceNavigation* Performance.navigation", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_PERFORMANCE_NAVIGATION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TIMING,
                                    g_param_spec_object("timing", /* name */
                                                           "performance_timing", /* short description */
                                                           "read-only  WebKitDOMPerformanceTiming* Performance.timing", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_PERFORMANCE_TIMING, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MEMORY,
                                    g_param_spec_object("memory", /* name */
                                                           "performance_memory", /* short description */
                                                           "read-only  WebKitDOMMemoryInfo* Performance.memory", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_MEMORY_INFO, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_performance_init(WebKitDOMPerformance* request)
{
    WebKitDOMPerformancePrivate* priv = WEBKIT_DOM_PERFORMANCE_GET_PRIVATE(request);
    new (priv) WebKitDOMPerformancePrivate();
}

gdouble
webkit_dom_performance_now(WebKitDOMPerformance* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE(self), 0);
    WebCore::Performance* item = WebKit::core(self);
    gdouble result = item->now();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return static_cast<gdouble>(0);
#endif /* ENABLE(WEB_TIMING) */
}

WebKitDOMPerformanceNavigation*
webkit_dom_performance_get_navigation(WebKitDOMPerformance* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE(self), 0);
    WebCore::Performance* item = WebKit::core(self);
    RefPtr<WebCore::PerformanceNavigation> gobjectResult = WTF::getPtr(item->navigation());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return 0;
#endif /* ENABLE(WEB_TIMING) */
}

WebKitDOMPerformanceTiming*
webkit_dom_performance_get_timing(WebKitDOMPerformance* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE(self), 0);
    WebCore::Performance* item = WebKit::core(self);
    RefPtr<WebCore::PerformanceTiming> gobjectResult = WTF::getPtr(item->timing());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return 0;
#endif /* ENABLE(WEB_TIMING) */
}

WebKitDOMMemoryInfo*
webkit_dom_performance_get_memory(WebKitDOMPerformance* self)
{
#if ENABLE(WEB_TIMING)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_PERFORMANCE(self), 0);
    WebCore::Performance* item = WebKit::core(self);
    RefPtr<WebCore::MemoryInfo> gobjectResult = WTF::getPtr(item->memory());
    return WebKit::kit(gobjectResult.get());
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Web Timing")
    return 0;
#endif /* ENABLE(WEB_TIMING) */
}

