/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMStyleMedia.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMStyleMediaPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_STYLE_MEDIA_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_STYLE_MEDIA, WebKitDOMStyleMediaPrivate)

typedef struct _WebKitDOMStyleMediaPrivate {
    RefPtr<WebCore::StyleMedia> coreObject;
} WebKitDOMStyleMediaPrivate;

namespace WebKit {

WebKitDOMStyleMedia* kit(WebCore::StyleMedia* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_STYLE_MEDIA(ret);

    return wrapStyleMedia(obj);
}

WebCore::StyleMedia* core(WebKitDOMStyleMedia* request)
{
    return request ? static_cast<WebCore::StyleMedia*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMStyleMedia* wrapStyleMedia(WebCore::StyleMedia* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_STYLE_MEDIA(g_object_new(WEBKIT_TYPE_DOM_STYLE_MEDIA, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMStyleMedia, webkit_dom_style_media, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_TYPE,
};

static void webkit_dom_style_media_finalize(GObject* object)
{
    WebKitDOMStyleMediaPrivate* priv = WEBKIT_DOM_STYLE_MEDIA_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMStyleMediaPrivate();
    G_OBJECT_CLASS(webkit_dom_style_media_parent_class)->finalize(object);
}

static void webkit_dom_style_media_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMStyleMedia* self = WEBKIT_DOM_STYLE_MEDIA(object);
    WebCore::StyleMedia* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->type()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_style_media_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_style_media_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMStyleMediaPrivate* priv = WEBKIT_DOM_STYLE_MEDIA_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::StyleMedia*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_style_media_class_init(WebKitDOMStyleMediaClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMStyleMediaPrivate));
    gobjectClass->constructor = webkit_dom_style_media_constructor;
    gobjectClass->finalize = webkit_dom_style_media_finalize;
    gobjectClass->get_property = webkit_dom_style_media_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "style_media_type", /* short description */
                                                           "read-only  gchar* StyleMedia.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_style_media_init(WebKitDOMStyleMedia* request)
{
    WebKitDOMStyleMediaPrivate* priv = WEBKIT_DOM_STYLE_MEDIA_GET_PRIVATE(request);
    new (priv) WebKitDOMStyleMediaPrivate();
}

gboolean
webkit_dom_style_media_match_medium(WebKitDOMStyleMedia* self, const gchar* mediaquery)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_STYLE_MEDIA(self), FALSE);
    g_return_val_if_fail(mediaquery, FALSE);
    WebCore::StyleMedia* item = WebKit::core(self);
    WTF::String convertedMediaquery = WTF::String::fromUTF8(mediaquery);
    gboolean result = item->matchMedium(convertedMediaquery);
    return result;
}

