/* engine.c generated by valac 0.38.8, the Vala compiler
 * generated from engine.vala, do not modify */

/* engine.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *             By Seif Lotfy <seif@lotfy.com>
 *
 * Based upon a Python implementation (2009-2011) by:
 *  Markus Korn <thekorn@gmx.net>
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@gmail.com>
 *  Seif Lotfy <seif@lotfy.com>
 *  Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "zeitgeist-internal.h"
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gobject/gvaluecollector.h>


#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
typedef struct _ZeitgeistEnginePrivate ZeitgeistEnginePrivate;

#define ZEITGEIST_TYPE_EXTENSION_STORE (zeitgeist_extension_store_get_type ())
#define ZEITGEIST_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStore))
#define ZEITGEIST_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))
#define ZEITGEIST_IS_EXTENSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_IS_EXTENSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_STORE))
#define ZEITGEIST_EXTENSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_STORE, ZeitgeistExtensionStoreClass))

typedef struct _ZeitgeistExtensionStore ZeitgeistExtensionStore;
typedef struct _ZeitgeistExtensionStoreClass ZeitgeistExtensionStoreClass;

#define ZEITGEIST_TYPE_EXTENSION_COLLECTION (zeitgeist_extension_collection_get_type ())
#define ZEITGEIST_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection))
#define ZEITGEIST_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))
#define ZEITGEIST_IS_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_IS_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_EXTENSION_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))

typedef struct _ZeitgeistExtensionCollection ZeitgeistExtensionCollection;
typedef struct _ZeitgeistExtensionCollectionClass ZeitgeistExtensionCollectionClass;
enum  {
	ZEITGEIST_ENGINE_0_PROPERTY,
	ZEITGEIST_ENGINE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_engine_properties[ZEITGEIST_ENGINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZEITGEIST_ENGINE_TYPE_DATA_INSERTER (zeitgeist_engine_data_inserter_get_type ())
#define ZEITGEIST_ENGINE_DATA_INSERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserter))
#define ZEITGEIST_ENGINE_DATA_INSERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserterClass))
#define ZEITGEIST_ENGINE_IS_DATA_INSERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER))
#define ZEITGEIST_ENGINE_IS_DATA_INSERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER))
#define ZEITGEIST_ENGINE_DATA_INSERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserterClass))

typedef struct _ZeitgeistEngineDataInserter ZeitgeistEngineDataInserter;
typedef struct _ZeitgeistEngineDataInserterClass ZeitgeistEngineDataInserterClass;
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))
#define _zeitgeist_engine_data_inserter_unref0(var) ((var == NULL) ? NULL : (var = (zeitgeist_engine_data_inserter_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ZeitgeistEngineDataInserterPrivate ZeitgeistEngineDataInserterPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _ZeitgeistEngineParamSpecDataInserter ZeitgeistEngineParamSpecDataInserter;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistEngine {
	ZeitgeistDbReader parent_instance;
	ZeitgeistEnginePrivate * priv;
	ZeitgeistExtensionStore* extension_store;
};

struct _ZeitgeistEngineClass {
	ZeitgeistDbReaderClass parent_class;
};

struct _ZeitgeistEnginePrivate {
	ZeitgeistExtensionCollection* extension_collection;
	guint32 last_id;
};

typedef GType (*ZeitgeistRegisterExtensionFunc) (GTypeModule* module);
struct _ZeitgeistEngineDataInserter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ZeitgeistEngineDataInserterPrivate * priv;
};

struct _ZeitgeistEngineDataInserterClass {
	GTypeClass parent_class;
	void (*finalize) (ZeitgeistEngineDataInserter *self);
};

struct _ZeitgeistEngineDataInserterPrivate {
	ZeitgeistSQLiteDatabase* database;
	gchar* type;
	GPtrArray* data;
};

struct _ZeitgeistEngineParamSpecDataInserter {
	GParamSpec parent_instance;
};


static gpointer zeitgeist_engine_parent_class = NULL;
static gpointer zeitgeist_engine_data_inserter_parent_class = NULL;

GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_store_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_collection_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_ENGINE, ZeitgeistEnginePrivate))
ZeitgeistEngine* zeitgeist_engine_new (GError** error);
ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1);
ZeitgeistEngine* zeitgeist_engine_new_with_builtins (ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1, GError** error);
ZeitgeistEngine* zeitgeist_engine_construct_with_builtins (GType object_type, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1, GError** error);
gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1);
gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1);
guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error);
static void zeitgeist_engine_preprocess_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error);
void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
static void zeitgeist_engine_insert_event_data (ZeitgeistEngine* self, GPtrArray* events, GError** error);
static guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error);
void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
static gpointer zeitgeist_engine_data_inserter_ref (gpointer instance);
static void zeitgeist_engine_data_inserter_unref (gpointer instance);
static GParamSpec* zeitgeist_engine_param_spec_data_inserter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void zeitgeist_engine_value_set_data_inserter (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void zeitgeist_engine_value_take_data_inserter (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer zeitgeist_engine_value_get_data_inserter (const GValue* value) G_GNUC_UNUSED;
static GType zeitgeist_engine_data_inserter_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_new (ZeitgeistSQLiteDatabase* db, const gchar* data_type);
static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_construct (GType object_type, ZeitgeistSQLiteDatabase* db, const gchar* data_type);
static void zeitgeist_engine_data_inserter_add (ZeitgeistEngineDataInserter* self, const gchar* val, GError** error);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void zeitgeist_engine_data_inserter_flush (ZeitgeistEngineDataInserter* self, GError** error);
static void zeitgeist_engine_bind_cached_reference (ZeitgeistEngine* self, sqlite3_stmt* stmt, gint position, ZeitgeistSQLiteTableLookup* table, const gchar* value_, GError** error);
static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self, ZeitgeistEvent* event);
static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self, ZeitgeistEvent* event);
ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error);
guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1);
void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender);
static void zeitgeist_engine_real_close (ZeitgeistDbReader* base);
static GObject * zeitgeist_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
ZeitgeistExtensionStore* zeitgeist_extension_store_new (ZeitgeistEngine* engine);
ZeitgeistExtensionStore* zeitgeist_extension_store_construct (GType object_type, ZeitgeistEngine* engine);
#define ZEITGEIST_ENGINE_DATA_INSERTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserterPrivate))
#define ZEITGEIST_ENGINE_DATA_INSERTER_MAX_PARAMETERS 500
static void zeitgeist_engine_data_inserter_finalize (ZeitgeistEngineDataInserter * obj);
static void zeitgeist_engine_finalize (GObject * obj);


ZeitgeistEngine* zeitgeist_engine_construct (GType object_type, GError** error) {
	ZeitgeistEngine * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	guint32 _tmp2_ = 0U;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	guint32 _tmp5_;
	ZeitgeistRegisterExtensionFunc* _tmp6_;
	ZeitgeistRegisterExtensionFunc* _tmp7_;
	gint _tmp7__length1;
	ZeitgeistExtensionCollection* _tmp8_;
	GError * _inner_error_ = NULL;
	_tmp1_ = zeitgeist_sq_lite_database_new (&_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self = (ZeitgeistEngine*) g_object_new (object_type, "database", _tmp0_, NULL);
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_sq_lite_database_get_last_id (_tmp4_, &_inner_error_);
	_tmp2_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->last_id = _tmp2_;
	_tmp6_ = g_new0 (ZeitgeistRegisterExtensionFunc, 0);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 0;
	_tmp8_ = zeitgeist_extension_collection_new (self, _tmp7_, 0);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = _tmp8_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}


ZeitgeistEngine* zeitgeist_engine_new (GError** error) {
	return zeitgeist_engine_construct (ZEITGEIST_TYPE_ENGINE, error);
}


ZeitgeistEngine* zeitgeist_engine_construct_with_builtins (GType object_type, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1, GError** error) {
	ZeitgeistEngine * self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_ = NULL;
	ZeitgeistSQLiteDatabase* _tmp1_;
	guint32 _tmp2_ = 0U;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	guint32 _tmp5_;
	ZeitgeistRegisterExtensionFunc* _tmp6_;
	gint _tmp6__length1;
	ZeitgeistExtensionCollection* _tmp7_;
	GError * _inner_error_ = NULL;
	_tmp1_ = zeitgeist_sq_lite_database_new (&_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self = (ZeitgeistEngine*) g_object_new (object_type, "database", _tmp0_, NULL);
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_sq_lite_database_get_last_id (_tmp4_, &_inner_error_);
	_tmp2_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (_tmp0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp0_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	self->priv->last_id = _tmp2_;
	_tmp6_ = builtins;
	_tmp6__length1 = builtins_length1;
	_tmp7_ = zeitgeist_extension_collection_new (self, _tmp6_, _tmp6__length1);
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = _tmp7_;
	_g_object_unref0 (_tmp0_);
	return self;
}


ZeitgeistEngine* zeitgeist_engine_new_with_builtins (ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1, GError** error) {
	return zeitgeist_engine_construct_with_builtins (ZEITGEIST_TYPE_ENGINE, builtins, builtins_length1, error);
}


gchar** zeitgeist_engine_get_extension_names (ZeitgeistEngine* self, int* result_length1) {
	gchar** result = NULL;
	ZeitgeistExtensionCollection* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->extension_collection;
	_tmp2_ = zeitgeist_extension_collection_get_extension_names (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


guint32* zeitgeist_engine_insert_events (ZeitgeistEngine* self, GPtrArray* events, const char* sender, int* result_length1, GError** error) {
	guint32* result = NULL;
	ZeitgeistExtensionCollection* _tmp9_;
	GPtrArray* _tmp10_;
	const char* _tmp11_;
	guint32* event_ids = NULL;
	GPtrArray* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	guint32* _tmp15_;
	gint event_ids_length1;
	gint _event_ids_size_;
	GError* err = NULL;
	ZeitgeistSQLiteDatabase* _tmp16_;
	ZeitgeistSQLiteDatabase* _tmp17_;
	GError* _tmp42_;
	ZeitgeistExtensionCollection* _tmp45_;
	GPtrArray* _tmp46_;
	const char* _tmp47_;
	guint32* _tmp48_;
	gint _tmp48__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (events != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = events;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = events;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				zeitgeist_engine_preprocess_event (self, (ZeitgeistEvent*) _tmp8_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return NULL;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
			}
		}
	}
	_tmp9_ = self->priv->extension_collection;
	_tmp10_ = events;
	_tmp11_ = sender;
	zeitgeist_extension_collection_call_pre_insert_events (_tmp9_, _tmp10_, _tmp11_);
	_tmp12_ = events;
	_tmp13_ = g_ptr_array_get_length (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_new0 (guint32, _tmp14_);
	event_ids = _tmp15_;
	event_ids_length1 = _tmp14_;
	_event_ids_size_ = event_ids_length1;
	err = NULL;
	_tmp16_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp17_ = _tmp16_;
	zeitgeist_sq_lite_database_begin_transaction (_tmp17_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GPtrArray* _tmp18_;
		ZeitgeistSQLiteDatabase* _tmp36_;
		ZeitgeistSQLiteDatabase* _tmp37_;
		_tmp18_ = events;
		zeitgeist_engine_insert_event_data (self, _tmp18_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp19_ = FALSE;
				_tmp19_ = TRUE;
				while (TRUE) {
					gint _tmp21_;
					GPtrArray* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					GPtrArray* _tmp25_;
					gint _tmp26_;
					gconstpointer _tmp27_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp19_ = FALSE;
					_tmp21_ = i;
					_tmp22_ = events;
					_tmp23_ = g_ptr_array_get_length (_tmp22_);
					_tmp24_ = _tmp23_;
					if (!(_tmp21_ < _tmp24_)) {
						break;
					}
					_tmp25_ = events;
					_tmp26_ = i;
					_tmp27_ = g_ptr_array_index (_tmp25_, (guint) _tmp26_);
					if (((ZeitgeistEvent*) _tmp27_) != NULL) {
						guint32 _tmp28_ = 0U;
						GPtrArray* _tmp29_;
						gint _tmp30_;
						gconstpointer _tmp31_;
						guint32 _tmp32_;
						guint32* _tmp33_;
						gint _tmp33__length1;
						gint _tmp34_;
						guint32 _tmp35_;
						_tmp29_ = events;
						_tmp30_ = i;
						_tmp31_ = g_ptr_array_index (_tmp29_, (guint) _tmp30_);
						_tmp32_ = zeitgeist_engine_insert_event (self, (ZeitgeistEvent*) _tmp31_, &_inner_error_);
						_tmp28_ = _tmp32_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								goto __catch0_zeitgeist_engine_error;
							}
							_g_error_free0 (err);
							event_ids = (g_free (event_ids), NULL);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
						_tmp33_ = event_ids;
						_tmp33__length1 = event_ids_length1;
						_tmp34_ = i;
						_tmp33_[_tmp34_] = _tmp28_;
						_tmp35_ = _tmp33_[_tmp34_];
					}
				}
			}
		}
		_tmp36_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp37_ = _tmp36_;
		zeitgeist_sq_lite_database_end_transaction (_tmp37_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				goto __catch0_zeitgeist_engine_error;
			}
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally0;
	__catch0_zeitgeist_engine_error:
	{
		GError* e = NULL;
		GError* _tmp38_;
		GError* _tmp39_;
		ZeitgeistSQLiteDatabase* _tmp40_;
		ZeitgeistSQLiteDatabase* _tmp41_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp38_ = e;
		_tmp39_ = _g_error_copy0 (_tmp38_);
		_g_error_free0 (err);
		err = _tmp39_;
		_tmp40_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp41_ = _tmp40_;
		zeitgeist_sq_lite_database_abort_transaction (_tmp41_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_error_free0 (e);
			goto __finally0;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp42_ = err;
	if (_tmp42_ != NULL) {
		GError* _tmp43_;
		GError* _tmp44_;
		_tmp43_ = err;
		_tmp44_ = _g_error_copy0 (_tmp43_);
		_inner_error_ = _tmp44_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			return NULL;
		} else {
			_g_error_free0 (err);
			event_ids = (g_free (event_ids), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp45_ = self->priv->extension_collection;
	_tmp46_ = events;
	_tmp47_ = sender;
	zeitgeist_extension_collection_call_post_insert_events (_tmp45_, _tmp46_, _tmp47_);
	_tmp48_ = event_ids;
	_tmp48__length1 = event_ids_length1;
	if (result_length1) {
		*result_length1 = _tmp48__length1;
	}
	result = _tmp48_;
	_g_error_free0 (err);
	return result;
}


static void zeitgeist_engine_preprocess_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ZeitgeistEvent* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp2_ = event;
	_tmp3_ = zeitgeist_event_get_interpretation (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_utils_is_empty_string (_tmp4_);
	if (_tmp5_) {
		_tmp1_ = TRUE;
	} else {
		ZeitgeistEvent* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = event;
		_tmp7_ = zeitgeist_event_get_manifestation (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = zeitgeist_utils_is_empty_string (_tmp8_);
		_tmp1_ = _tmp9_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ZeitgeistEvent* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp10_ = event;
		_tmp11_ = zeitgeist_event_get_actor (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = zeitgeist_utils_is_empty_string (_tmp12_);
		_tmp0_ = _tmp13_;
	}
	if (_tmp0_) {
		GError* _tmp14_;
		_tmp14_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Incomplete event: interpretation, manifestation and actor " "are required");
		_inner_error_ = _tmp14_;
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				ZeitgeistEvent* _tmp18_;
				gint _tmp19_;
				ZeitgeistSubject* subject = NULL;
				ZeitgeistEvent* _tmp20_;
				GPtrArray* _tmp21_;
				GPtrArray* _tmp22_;
				gint _tmp23_;
				gconstpointer _tmp24_;
				ZeitgeistSubject* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gboolean _tmp28_;
				ZeitgeistSubject* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				gboolean _tmp33_;
				ZeitgeistSubject* _tmp38_;
				const gchar* _tmp39_;
				const gchar* _tmp40_;
				gboolean _tmp41_;
				gboolean _tmp46_ = FALSE;
				ZeitgeistEvent* _tmp47_;
				const gchar* _tmp48_;
				const gchar* _tmp49_;
				gboolean _tmp68_ = FALSE;
				ZeitgeistEvent* _tmp69_;
				const gchar* _tmp70_;
				const gchar* _tmp71_;
				ZeitgeistSubject* _tmp79_;
				const gchar* _tmp80_;
				const gchar* _tmp81_;
				gboolean _tmp82_;
				ZeitgeistSubject* _tmp90_;
				const gchar* _tmp91_;
				const gchar* _tmp92_;
				gboolean _tmp93_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = event;
				_tmp19_ = zeitgeist_event_num_subjects (_tmp18_);
				if (!(_tmp17_ < _tmp19_)) {
					break;
				}
				_tmp20_ = event;
				_tmp21_ = zeitgeist_event_get_subjects (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = i;
				_tmp24_ = g_ptr_array_index (_tmp22_, (guint) _tmp23_);
				subject = (ZeitgeistSubject*) _tmp24_;
				_tmp25_ = subject;
				_tmp26_ = zeitgeist_subject_get_uri (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = zeitgeist_utils_is_empty_string (_tmp27_);
				if (_tmp28_) {
					GError* _tmp29_;
					_tmp29_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Incomplete event: subject without URI");
					_inner_error_ = _tmp29_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp30_ = subject;
				_tmp31_ = zeitgeist_subject_get_current_uri (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = zeitgeist_utils_is_empty_string (_tmp32_);
				if (_tmp33_) {
					ZeitgeistSubject* _tmp34_;
					ZeitgeistSubject* _tmp35_;
					const gchar* _tmp36_;
					const gchar* _tmp37_;
					_tmp34_ = subject;
					_tmp35_ = subject;
					_tmp36_ = zeitgeist_subject_get_uri (_tmp35_);
					_tmp37_ = _tmp36_;
					zeitgeist_subject_set_current_uri (_tmp34_, _tmp37_);
				}
				_tmp38_ = subject;
				_tmp39_ = zeitgeist_subject_get_current_origin (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = zeitgeist_utils_is_empty_string (_tmp40_);
				if (_tmp41_) {
					ZeitgeistSubject* _tmp42_;
					ZeitgeistSubject* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					_tmp42_ = subject;
					_tmp43_ = subject;
					_tmp44_ = zeitgeist_subject_get_origin (_tmp43_);
					_tmp45_ = _tmp44_;
					zeitgeist_subject_set_current_origin (_tmp42_, _tmp45_);
				}
				_tmp47_ = event;
				_tmp48_ = zeitgeist_event_get_interpretation (_tmp47_);
				_tmp49_ = _tmp48_;
				if (g_strcmp0 (_tmp49_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
					ZeitgeistSubject* _tmp50_;
					const gchar* _tmp51_;
					const gchar* _tmp52_;
					ZeitgeistSubject* _tmp53_;
					const gchar* _tmp54_;
					const gchar* _tmp55_;
					_tmp50_ = subject;
					_tmp51_ = zeitgeist_subject_get_uri (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = subject;
					_tmp54_ = zeitgeist_subject_get_current_uri (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp46_ = g_strcmp0 (_tmp52_, _tmp55_) == 0;
				} else {
					_tmp46_ = FALSE;
				}
				if (_tmp46_) {
					GError* _tmp56_;
					_tmp56_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Redundant event: event.interpretation indicates " "the uri has been moved yet the subject.uri and " "subject.current_uri are identical");
					_inner_error_ = _tmp56_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				} else {
					gboolean _tmp57_ = FALSE;
					ZeitgeistEvent* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					_tmp58_ = event;
					_tmp59_ = zeitgeist_event_get_interpretation (_tmp58_);
					_tmp60_ = _tmp59_;
					if (g_strcmp0 (_tmp60_, ZEITGEIST_ZG_MOVE_EVENT) != 0) {
						ZeitgeistSubject* _tmp61_;
						const gchar* _tmp62_;
						const gchar* _tmp63_;
						ZeitgeistSubject* _tmp64_;
						const gchar* _tmp65_;
						const gchar* _tmp66_;
						_tmp61_ = subject;
						_tmp62_ = zeitgeist_subject_get_uri (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp64_ = subject;
						_tmp65_ = zeitgeist_subject_get_current_uri (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp57_ = g_strcmp0 (_tmp63_, _tmp66_) != 0;
					} else {
						_tmp57_ = FALSE;
					}
					if (_tmp57_) {
						GError* _tmp67_;
						_tmp67_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Illegal event: unless event.interpretation is " "'MOVE_EVENT' then subject.uri and " "subject.current_uri have to be the same");
						_inner_error_ = _tmp67_;
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				_tmp69_ = event;
				_tmp70_ = zeitgeist_event_get_interpretation (_tmp69_);
				_tmp71_ = _tmp70_;
				if (g_strcmp0 (_tmp71_, ZEITGEIST_ZG_MOVE_EVENT) != 0) {
					ZeitgeistSubject* _tmp72_;
					const gchar* _tmp73_;
					const gchar* _tmp74_;
					ZeitgeistSubject* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp72_ = subject;
					_tmp73_ = zeitgeist_subject_get_origin (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = subject;
					_tmp76_ = zeitgeist_subject_get_current_origin (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp68_ = g_strcmp0 (_tmp74_, _tmp77_) != 0;
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					GError* _tmp78_;
					_tmp78_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_ARGUMENT, "Illegal event: unless event.interpretation is " "'MOVE_EVENT' then subject.origin and " "subject.current_origin have to be the same");
					_inner_error_ = _tmp78_;
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp79_ = subject;
				_tmp80_ = zeitgeist_subject_get_manifestation (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = zeitgeist_utils_is_empty_string (_tmp81_);
				if (_tmp82_) {
					const gchar* manifestation = NULL;
					ZeitgeistSubject* _tmp83_;
					const gchar* _tmp84_;
					const gchar* _tmp85_;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					_tmp83_ = subject;
					_tmp84_ = zeitgeist_subject_get_uri (_tmp83_);
					_tmp85_ = _tmp84_;
					_tmp86_ = zeitgeist_manifestation_for_uri (_tmp85_);
					manifestation = _tmp86_;
					_tmp87_ = manifestation;
					if (_tmp87_ != NULL) {
						ZeitgeistSubject* _tmp88_;
						const gchar* _tmp89_;
						_tmp88_ = subject;
						_tmp89_ = manifestation;
						zeitgeist_subject_set_manifestation (_tmp88_, _tmp89_);
					}
				}
				_tmp90_ = subject;
				_tmp91_ = zeitgeist_subject_get_interpretation (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = zeitgeist_utils_is_empty_string (_tmp92_);
				if (_tmp93_) {
					const gchar* interpretation = NULL;
					ZeitgeistSubject* _tmp94_;
					const gchar* _tmp95_;
					const gchar* _tmp96_;
					const gchar* _tmp97_;
					const gchar* _tmp98_;
					_tmp94_ = subject;
					_tmp95_ = zeitgeist_subject_get_mimetype (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = zeitgeist_interpretation_for_mimetype (_tmp96_);
					interpretation = _tmp97_;
					_tmp98_ = interpretation;
					if (_tmp98_ != NULL) {
						ZeitgeistSubject* _tmp99_;
						const gchar* _tmp100_;
						_tmp99_ = subject;
						_tmp100_ = interpretation;
						zeitgeist_subject_set_interpretation (_tmp99_, _tmp100_);
					}
				}
			}
		}
	}
}


/**
     * Makes sure all the URIs, texts and storage values used
     * by the given events are in the database.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static inline void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}


static void zeitgeist_engine_insert_event_data (ZeitgeistEngine* self, GPtrArray* events, GError** error) {
	ZeitgeistEngineDataInserter* uris = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	ZeitgeistEngineDataInserter* _tmp2_;
	ZeitgeistEngineDataInserter* texts = NULL;
	ZeitgeistSQLiteDatabase* _tmp3_;
	ZeitgeistSQLiteDatabase* _tmp4_;
	ZeitgeistEngineDataInserter* _tmp5_;
	ZeitgeistEngineDataInserter* storages = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_;
	ZeitgeistSQLiteDatabase* _tmp7_;
	ZeitgeistEngineDataInserter* _tmp8_;
	ZeitgeistEngineDataInserter* _tmp99_;
	ZeitgeistEngineDataInserter* _tmp100_;
	ZeitgeistEngineDataInserter* _tmp101_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_engine_data_inserter_new (_tmp1_, "uri");
	uris = _tmp2_;
	_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_engine_data_inserter_new (_tmp4_, "text");
	texts = _tmp5_;
	_tmp6_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = zeitgeist_engine_data_inserter_new (_tmp7_, "storage");
	storages = _tmp8_;
	{
		gint j = 0;
		j = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_;
				GPtrArray* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GPtrArray* _tmp15_;
				gint _tmp16_;
				gconstpointer _tmp17_;
				ZeitgeistEvent* event = NULL;
				GPtrArray* _tmp18_;
				gint _tmp19_;
				gconstpointer _tmp20_;
				ZeitgeistEvent* _tmp21_;
				GSList* subj_uris = NULL;
				ZeitgeistEvent* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gboolean _tmp25_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = j;
					j = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = j;
				_tmp12_ = events;
				_tmp13_ = g_ptr_array_get_length (_tmp12_);
				_tmp14_ = _tmp13_;
				if (!(_tmp11_ < _tmp14_)) {
					break;
				}
				_tmp15_ = events;
				_tmp16_ = j;
				_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
				if (((ZeitgeistEvent*) _tmp17_) == NULL) {
					continue;
				}
				_tmp18_ = events;
				_tmp19_ = j;
				_tmp20_ = g_ptr_array_index (_tmp18_, (guint) _tmp19_);
				_tmp21_ = _g_object_ref0 ((ZeitgeistEvent*) _tmp20_);
				event = _tmp21_;
				subj_uris = NULL;
				_tmp22_ = event;
				_tmp23_ = zeitgeist_event_get_origin (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = zeitgeist_utils_is_empty_string (_tmp24_);
				if (!_tmp25_) {
					ZeitgeistEngineDataInserter* _tmp26_;
					ZeitgeistEvent* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					_tmp26_ = uris;
					_tmp27_ = event;
					_tmp28_ = zeitgeist_event_get_origin (_tmp27_);
					_tmp29_ = _tmp28_;
					zeitgeist_engine_data_inserter_add (_tmp26_, _tmp29_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							g_propagate_error (error, _inner_error_);
							__g_slist_free__g_free0_0 (subj_uris);
							_g_object_unref0 (event);
							_zeitgeist_engine_data_inserter_unref0 (storages);
							_zeitgeist_engine_data_inserter_unref0 (texts);
							_zeitgeist_engine_data_inserter_unref0 (uris);
							return;
						} else {
							__g_slist_free__g_free0_0 (subj_uris);
							_g_object_unref0 (event);
							_zeitgeist_engine_data_inserter_unref0 (storages);
							_zeitgeist_engine_data_inserter_unref0 (texts);
							_zeitgeist_engine_data_inserter_unref0 (uris);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp30_ = FALSE;
						_tmp30_ = TRUE;
						while (TRUE) {
							gint _tmp32_;
							ZeitgeistEvent* _tmp33_;
							gint _tmp34_;
							ZeitgeistSubject* subject = NULL;
							ZeitgeistEvent* _tmp35_;
							GPtrArray* _tmp36_;
							GPtrArray* _tmp37_;
							gint _tmp38_;
							gconstpointer _tmp39_;
							GSList* _tmp40_;
							ZeitgeistSubject* _tmp41_;
							const gchar* _tmp42_;
							const gchar* _tmp43_;
							GCompareFunc _tmp44_;
							GSList* _tmp45_;
							ZeitgeistSubject* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							ZeitgeistEngineDataInserter* _tmp51_;
							ZeitgeistSubject* _tmp52_;
							const gchar* _tmp53_;
							const gchar* _tmp54_;
							ZeitgeistSubject* _tmp55_;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							ZeitgeistSubject* _tmp58_;
							const gchar* _tmp59_;
							const gchar* _tmp60_;
							ZeitgeistSubject* _tmp65_;
							const gchar* _tmp66_;
							const gchar* _tmp67_;
							ZeitgeistSubject* _tmp68_;
							const gchar* _tmp69_;
							const gchar* _tmp70_;
							ZeitgeistSubject* _tmp75_;
							const gchar* _tmp76_;
							const gchar* _tmp77_;
							gboolean _tmp78_;
							ZeitgeistSubject* _tmp83_;
							const gchar* _tmp84_;
							const gchar* _tmp85_;
							gboolean _tmp86_;
							ZeitgeistSubject* _tmp91_;
							const gchar* _tmp92_;
							const gchar* _tmp93_;
							gboolean _tmp94_;
							if (!_tmp30_) {
								gint _tmp31_;
								_tmp31_ = i;
								i = _tmp31_ + 1;
							}
							_tmp30_ = FALSE;
							_tmp32_ = i;
							_tmp33_ = event;
							_tmp34_ = zeitgeist_event_num_subjects (_tmp33_);
							if (!(_tmp32_ < _tmp34_)) {
								break;
							}
							_tmp35_ = event;
							_tmp36_ = zeitgeist_event_get_subjects (_tmp35_);
							_tmp37_ = _tmp36_;
							_tmp38_ = i;
							_tmp39_ = g_ptr_array_index (_tmp37_, (guint) _tmp38_);
							subject = (ZeitgeistSubject*) _tmp39_;
							_tmp40_ = subj_uris;
							_tmp41_ = subject;
							_tmp42_ = zeitgeist_subject_get_uri (_tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = g_strcmp0;
							_tmp45_ = g_slist_find_custom (_tmp40_, _tmp43_, _tmp44_);
							if (_tmp45_ != NULL) {
								GError* _tmp46_;
								_tmp46_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_INVALID_EVENT, "Events with two subjects with the same URI are not supported");
								_inner_error_ = _tmp46_;
								if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
									g_propagate_error (error, _inner_error_);
									__g_slist_free__g_free0_0 (subj_uris);
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									return;
								} else {
									__g_slist_free__g_free0_0 (subj_uris);
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp47_ = subject;
							_tmp48_ = zeitgeist_subject_get_uri (_tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = g_strdup (_tmp49_);
							subj_uris = g_slist_append (subj_uris, _tmp50_);
							_tmp51_ = uris;
							_tmp52_ = subject;
							_tmp53_ = zeitgeist_subject_get_uri (_tmp52_);
							_tmp54_ = _tmp53_;
							zeitgeist_engine_data_inserter_add (_tmp51_, _tmp54_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
									g_propagate_error (error, _inner_error_);
									__g_slist_free__g_free0_0 (subj_uris);
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									return;
								} else {
									__g_slist_free__g_free0_0 (subj_uris);
									_g_object_unref0 (event);
									_zeitgeist_engine_data_inserter_unref0 (storages);
									_zeitgeist_engine_data_inserter_unref0 (texts);
									_zeitgeist_engine_data_inserter_unref0 (uris);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
									g_clear_error (&_inner_error_);
									return;
								}
							}
							_tmp55_ = subject;
							_tmp56_ = zeitgeist_subject_get_uri (_tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = subject;
							_tmp59_ = zeitgeist_subject_get_current_uri (_tmp58_);
							_tmp60_ = _tmp59_;
							if (g_strcmp0 (_tmp57_, _tmp60_) != 0) {
								ZeitgeistEngineDataInserter* _tmp61_;
								ZeitgeistSubject* _tmp62_;
								const gchar* _tmp63_;
								const gchar* _tmp64_;
								_tmp61_ = uris;
								_tmp62_ = subject;
								_tmp63_ = zeitgeist_subject_get_current_uri (_tmp62_);
								_tmp64_ = _tmp63_;
								zeitgeist_engine_data_inserter_add (_tmp61_, _tmp64_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp65_ = subject;
							_tmp66_ = zeitgeist_subject_get_origin (_tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = subject;
							_tmp69_ = zeitgeist_subject_get_current_origin (_tmp68_);
							_tmp70_ = _tmp69_;
							if (g_strcmp0 (_tmp67_, _tmp70_) != 0) {
								ZeitgeistEngineDataInserter* _tmp71_;
								ZeitgeistSubject* _tmp72_;
								const gchar* _tmp73_;
								const gchar* _tmp74_;
								_tmp71_ = uris;
								_tmp72_ = subject;
								_tmp73_ = zeitgeist_subject_get_current_origin (_tmp72_);
								_tmp74_ = _tmp73_;
								zeitgeist_engine_data_inserter_add (_tmp71_, _tmp74_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp75_ = subject;
							_tmp76_ = zeitgeist_subject_get_origin (_tmp75_);
							_tmp77_ = _tmp76_;
							_tmp78_ = zeitgeist_utils_is_empty_string (_tmp77_);
							if (!_tmp78_) {
								ZeitgeistEngineDataInserter* _tmp79_;
								ZeitgeistSubject* _tmp80_;
								const gchar* _tmp81_;
								const gchar* _tmp82_;
								_tmp79_ = uris;
								_tmp80_ = subject;
								_tmp81_ = zeitgeist_subject_get_origin (_tmp80_);
								_tmp82_ = _tmp81_;
								zeitgeist_engine_data_inserter_add (_tmp79_, _tmp82_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp83_ = subject;
							_tmp84_ = zeitgeist_subject_get_text (_tmp83_);
							_tmp85_ = _tmp84_;
							_tmp86_ = zeitgeist_utils_is_empty_string (_tmp85_);
							if (!_tmp86_) {
								ZeitgeistEngineDataInserter* _tmp87_;
								ZeitgeistSubject* _tmp88_;
								const gchar* _tmp89_;
								const gchar* _tmp90_;
								_tmp87_ = texts;
								_tmp88_ = subject;
								_tmp89_ = zeitgeist_subject_get_text (_tmp88_);
								_tmp90_ = _tmp89_;
								zeitgeist_engine_data_inserter_add (_tmp87_, _tmp90_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
							_tmp91_ = subject;
							_tmp92_ = zeitgeist_subject_get_storage (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = zeitgeist_utils_is_empty_string (_tmp93_);
							if (!_tmp94_) {
								ZeitgeistEngineDataInserter* _tmp95_;
								ZeitgeistSubject* _tmp96_;
								const gchar* _tmp97_;
								const gchar* _tmp98_;
								_tmp95_ = storages;
								_tmp96_ = subject;
								_tmp97_ = zeitgeist_subject_get_storage (_tmp96_);
								_tmp98_ = _tmp97_;
								zeitgeist_engine_data_inserter_add (_tmp95_, _tmp98_, &_inner_error_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
										g_propagate_error (error, _inner_error_);
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										return;
									} else {
										__g_slist_free__g_free0_0 (subj_uris);
										_g_object_unref0 (event);
										_zeitgeist_engine_data_inserter_unref0 (storages);
										_zeitgeist_engine_data_inserter_unref0 (texts);
										_zeitgeist_engine_data_inserter_unref0 (uris);
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
										g_clear_error (&_inner_error_);
										return;
									}
								}
							}
						}
					}
				}
				__g_slist_free__g_free0_0 (subj_uris);
				_g_object_unref0 (event);
			}
		}
	}
	_tmp99_ = uris;
	zeitgeist_engine_data_inserter_flush (_tmp99_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp100_ = texts;
	zeitgeist_engine_data_inserter_flush (_tmp100_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp101_ = storages;
	zeitgeist_engine_data_inserter_flush (_tmp101_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			return;
		} else {
			_zeitgeist_engine_data_inserter_unref0 (storages);
			_zeitgeist_engine_data_inserter_unref0 (texts);
			_zeitgeist_engine_data_inserter_unref0 (uris);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_zeitgeist_engine_data_inserter_unref0 (storages);
	_zeitgeist_engine_data_inserter_unref0 (texts);
	_zeitgeist_engine_data_inserter_unref0 (uris);
}


static void zeitgeist_engine_bind_cached_reference (ZeitgeistEngine* self, sqlite3_stmt* stmt, gint position, ZeitgeistSQLiteTableLookup* table, const gchar* value_, GError** error) {
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (table != NULL);
	_tmp0_ = value_;
	if (_tmp0_ != NULL) {
		gint _tmp1_ = 0;
		ZeitgeistSQLiteTableLookup* _tmp2_;
		const gchar* _tmp3_;
		gint _tmp4_;
		sqlite3_stmt* _tmp5_;
		gint _tmp6_;
		_tmp2_ = table;
		_tmp3_ = value_;
		_tmp4_ = zeitgeist_sq_lite_table_lookup_id_for_string (_tmp2_, _tmp3_, &_inner_error_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp5_ = stmt;
		_tmp6_ = position;
		sqlite3_bind_int64 (_tmp5_, _tmp6_, (gint64) _tmp1_);
	} else {
		sqlite3_stmt* _tmp7_;
		gint _tmp8_;
		_tmp7_ = stmt;
		_tmp8_ = position;
		sqlite3_bind_null (_tmp7_, _tmp8_);
	}
}


static guint32 zeitgeist_engine_insert_event (ZeitgeistEngine* self, ZeitgeistEvent* event, GError** error) {
	guint32 result = 0U;
	ZeitgeistEvent* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	ZeitgeistEvent* _tmp3_;
	gint _tmp4_;
	ZeitgeistEvent* _tmp5_;
	guint32 _tmp6_;
	guint32 _tmp7_;
	gint64 payload_id = 0LL;
	ZeitgeistEvent* _tmp8_;
	gint64 _tmp9_;
	gint rc = 0;
	sqlite3_stmt* insert_stmt = NULL;
	ZeitgeistSQLiteDatabase* _tmp10_;
	ZeitgeistSQLiteDatabase* _tmp11_;
	sqlite3_stmt* _tmp12_;
	ZeitgeistEvent* _tmp173_;
	const gchar* _tmp174_;
	const gchar* _tmp175_;
	ZeitgeistEvent* _tmp177_;
	guint32 _tmp178_;
	guint32 _tmp179_;
	ZeitgeistEvent* _tmp182_;
	guint32 _tmp183_;
	guint32 _tmp184_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (event != NULL, 0U);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_val_if_fail (_tmp2_ == ((guint32) 0), "event.id == 0", 0U);
	_tmp3_ = event;
	_tmp4_ = zeitgeist_event_num_subjects (_tmp3_);
	_vala_return_val_if_fail (_tmp4_ > 0, "event.num_subjects () > 0", 0U);
	_tmp5_ = event;
	_tmp6_ = self->priv->last_id;
	self->priv->last_id = _tmp6_ + 1;
	_tmp7_ = self->priv->last_id;
	zeitgeist_event_set_id (_tmp5_, _tmp7_);
	_tmp8_ = event;
	_tmp9_ = zeitgeist_engine_store_payload (self, _tmp8_);
	payload_id = _tmp9_;
	_tmp10_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->event_insertion_stmt;
	insert_stmt = _tmp12_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint _tmp15_;
				ZeitgeistEvent* _tmp16_;
				gint _tmp17_;
				sqlite3_stmt* _tmp18_;
				sqlite3_stmt* _tmp19_;
				ZeitgeistEvent* _tmp20_;
				guint32 _tmp21_;
				guint32 _tmp22_;
				sqlite3_stmt* _tmp23_;
				ZeitgeistEvent* _tmp24_;
				gint64 _tmp25_;
				gint64 _tmp26_;
				sqlite3_stmt* _tmp27_;
				ZeitgeistSQLiteTableLookup* _tmp28_;
				ZeitgeistEvent* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				sqlite3_stmt* _tmp34_;
				ZeitgeistSQLiteTableLookup* _tmp35_;
				ZeitgeistEvent* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				sqlite3_stmt* _tmp41_;
				ZeitgeistSQLiteTableLookup* _tmp42_;
				ZeitgeistEvent* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				sqlite3_stmt* _tmp48_;
				ZeitgeistEvent* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				GDestroyNotify _tmp53_;
				sqlite3_stmt* _tmp54_;
				gint64 _tmp55_;
				ZeitgeistSubject* subject = NULL;
				ZeitgeistEvent* _tmp56_;
				GPtrArray* _tmp57_;
				GPtrArray* _tmp58_;
				gint _tmp59_;
				gconstpointer _tmp60_;
				sqlite3_stmt* _tmp61_;
				ZeitgeistSubject* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				gchar* _tmp65_;
				GDestroyNotify _tmp66_;
				sqlite3_stmt* _tmp67_;
				ZeitgeistSubject* _tmp68_;
				const gchar* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_;
				GDestroyNotify _tmp72_;
				sqlite3_stmt* _tmp73_;
				ZeitgeistSQLiteTableLookup* _tmp74_;
				ZeitgeistSubject* _tmp75_;
				const gchar* _tmp76_;
				const gchar* _tmp77_;
				sqlite3_stmt* _tmp80_;
				ZeitgeistSQLiteTableLookup* _tmp81_;
				ZeitgeistSubject* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				sqlite3_stmt* _tmp87_;
				ZeitgeistSubject* _tmp88_;
				const gchar* _tmp89_;
				const gchar* _tmp90_;
				gchar* _tmp91_;
				GDestroyNotify _tmp92_;
				sqlite3_stmt* _tmp93_;
				ZeitgeistSubject* _tmp94_;
				const gchar* _tmp95_;
				const gchar* _tmp96_;
				gchar* _tmp97_;
				GDestroyNotify _tmp98_;
				sqlite3_stmt* _tmp99_;
				ZeitgeistSQLiteTableLookup* _tmp100_;
				ZeitgeistSubject* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				sqlite3_stmt* _tmp106_;
				ZeitgeistSubject* _tmp107_;
				const gchar* _tmp108_;
				const gchar* _tmp109_;
				gchar* _tmp110_;
				GDestroyNotify _tmp111_;
				sqlite3_stmt* _tmp112_;
				ZeitgeistSubject* _tmp113_;
				const gchar* _tmp114_;
				const gchar* _tmp115_;
				gchar* _tmp116_;
				GDestroyNotify _tmp117_;
				sqlite3_stmt* _tmp118_;
				gint _tmp119_;
				gint _tmp120_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = i;
				_tmp16_ = event;
				_tmp17_ = zeitgeist_event_num_subjects (_tmp16_);
				if (!(_tmp15_ < _tmp17_)) {
					break;
				}
				_tmp18_ = insert_stmt;
				sqlite3_reset (_tmp18_);
				_tmp19_ = insert_stmt;
				_tmp20_ = event;
				_tmp21_ = zeitgeist_event_get_id (_tmp20_);
				_tmp22_ = _tmp21_;
				sqlite3_bind_int64 (_tmp19_, 1, (gint64) _tmp22_);
				_tmp23_ = insert_stmt;
				_tmp24_ = event;
				_tmp25_ = zeitgeist_event_get_timestamp (_tmp24_);
				_tmp26_ = _tmp25_;
				sqlite3_bind_int64 (_tmp23_, 2, _tmp26_);
				_tmp27_ = insert_stmt;
				_tmp28_ = ((ZeitgeistDbReader*) self)->interpretations_table;
				_tmp29_ = event;
				_tmp30_ = zeitgeist_event_get_interpretation (_tmp29_);
				_tmp31_ = _tmp30_;
				zeitgeist_engine_bind_cached_reference (self, _tmp27_, 3, _tmp28_, _tmp31_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp32_ = 0U;
						g_propagate_error (error, _inner_error_);
						return _tmp32_;
					} else {
						guint32 _tmp33_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp33_;
					}
				}
				_tmp34_ = insert_stmt;
				_tmp35_ = ((ZeitgeistDbReader*) self)->manifestations_table;
				_tmp36_ = event;
				_tmp37_ = zeitgeist_event_get_manifestation (_tmp36_);
				_tmp38_ = _tmp37_;
				zeitgeist_engine_bind_cached_reference (self, _tmp34_, 4, _tmp35_, _tmp38_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp39_ = 0U;
						g_propagate_error (error, _inner_error_);
						return _tmp39_;
					} else {
						guint32 _tmp40_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp40_;
					}
				}
				_tmp41_ = insert_stmt;
				_tmp42_ = ((ZeitgeistDbReader*) self)->actors_table;
				_tmp43_ = event;
				_tmp44_ = zeitgeist_event_get_actor (_tmp43_);
				_tmp45_ = _tmp44_;
				zeitgeist_engine_bind_cached_reference (self, _tmp41_, 5, _tmp42_, _tmp45_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp46_ = 0U;
						g_propagate_error (error, _inner_error_);
						return _tmp46_;
					} else {
						guint32 _tmp47_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp47_;
					}
				}
				_tmp48_ = insert_stmt;
				_tmp49_ = event;
				_tmp50_ = zeitgeist_event_get_origin (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strdup (_tmp51_);
				_tmp53_ = g_free;
				sqlite3_bind_text (_tmp48_, 6, _tmp52_, -1, _tmp53_);
				_tmp54_ = insert_stmt;
				_tmp55_ = payload_id;
				sqlite3_bind_int64 (_tmp54_, 7, _tmp55_);
				_tmp56_ = event;
				_tmp57_ = zeitgeist_event_get_subjects (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = i;
				_tmp60_ = g_ptr_array_index (_tmp58_, (guint) _tmp59_);
				subject = (ZeitgeistSubject*) _tmp60_;
				_tmp61_ = insert_stmt;
				_tmp62_ = subject;
				_tmp63_ = zeitgeist_subject_get_uri (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup (_tmp64_);
				_tmp66_ = g_free;
				sqlite3_bind_text (_tmp61_, 8, _tmp65_, -1, _tmp66_);
				_tmp67_ = insert_stmt;
				_tmp68_ = subject;
				_tmp69_ = zeitgeist_subject_get_current_uri (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = g_strdup (_tmp70_);
				_tmp72_ = g_free;
				sqlite3_bind_text (_tmp67_, 9, _tmp71_, -1, _tmp72_);
				_tmp73_ = insert_stmt;
				_tmp74_ = ((ZeitgeistDbReader*) self)->interpretations_table;
				_tmp75_ = subject;
				_tmp76_ = zeitgeist_subject_get_interpretation (_tmp75_);
				_tmp77_ = _tmp76_;
				zeitgeist_engine_bind_cached_reference (self, _tmp73_, 10, _tmp74_, _tmp77_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp78_ = 0U;
						g_propagate_error (error, _inner_error_);
						return _tmp78_;
					} else {
						guint32 _tmp79_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp79_;
					}
				}
				_tmp80_ = insert_stmt;
				_tmp81_ = ((ZeitgeistDbReader*) self)->manifestations_table;
				_tmp82_ = subject;
				_tmp83_ = zeitgeist_subject_get_manifestation (_tmp82_);
				_tmp84_ = _tmp83_;
				zeitgeist_engine_bind_cached_reference (self, _tmp80_, 11, _tmp81_, _tmp84_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp85_ = 0U;
						g_propagate_error (error, _inner_error_);
						return _tmp85_;
					} else {
						guint32 _tmp86_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp86_;
					}
				}
				_tmp87_ = insert_stmt;
				_tmp88_ = subject;
				_tmp89_ = zeitgeist_subject_get_origin (_tmp88_);
				_tmp90_ = _tmp89_;
				_tmp91_ = g_strdup (_tmp90_);
				_tmp92_ = g_free;
				sqlite3_bind_text (_tmp87_, 12, _tmp91_, -1, _tmp92_);
				_tmp93_ = insert_stmt;
				_tmp94_ = subject;
				_tmp95_ = zeitgeist_subject_get_current_origin (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = g_strdup (_tmp96_);
				_tmp98_ = g_free;
				sqlite3_bind_text (_tmp93_, 13, _tmp97_, -1, _tmp98_);
				_tmp99_ = insert_stmt;
				_tmp100_ = ((ZeitgeistDbReader*) self)->mimetypes_table;
				_tmp101_ = subject;
				_tmp102_ = zeitgeist_subject_get_mimetype (_tmp101_);
				_tmp103_ = _tmp102_;
				zeitgeist_engine_bind_cached_reference (self, _tmp99_, 14, _tmp100_, _tmp103_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
						guint32 _tmp104_ = 0U;
						g_propagate_error (error, _inner_error_);
						return _tmp104_;
					} else {
						guint32 _tmp105_ = 0U;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp105_;
					}
				}
				_tmp106_ = insert_stmt;
				_tmp107_ = subject;
				_tmp108_ = zeitgeist_subject_get_text (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = g_strdup (_tmp109_);
				_tmp111_ = g_free;
				sqlite3_bind_text (_tmp106_, 15, _tmp110_, -1, _tmp111_);
				_tmp112_ = insert_stmt;
				_tmp113_ = subject;
				_tmp114_ = zeitgeist_subject_get_storage (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = g_strdup (_tmp115_);
				_tmp117_ = g_free;
				sqlite3_bind_text (_tmp112_, 16, _tmp116_, -1, _tmp117_);
				_tmp118_ = insert_stmt;
				_tmp119_ = sqlite3_step (_tmp118_);
				rc = _tmp119_;
				_tmp120_ = rc;
				if (_tmp120_ != SQLITE_DONE) {
					gint _tmp121_;
					guint32 _tmp130_;
					sqlite3_stmt* retrieval_stmt = NULL;
					ZeitgeistSQLiteDatabase* _tmp131_;
					ZeitgeistSQLiteDatabase* _tmp132_;
					sqlite3_stmt* _tmp133_;
					sqlite3_stmt* _tmp134_;
					sqlite3_stmt* _tmp135_;
					ZeitgeistEvent* _tmp136_;
					gint64 _tmp137_;
					gint64 _tmp138_;
					sqlite3_stmt* _tmp139_;
					ZeitgeistSQLiteTableLookup* _tmp140_;
					ZeitgeistEvent* _tmp141_;
					const gchar* _tmp142_;
					const gchar* _tmp143_;
					sqlite3_stmt* _tmp146_;
					ZeitgeistSQLiteTableLookup* _tmp147_;
					ZeitgeistEvent* _tmp148_;
					const gchar* _tmp149_;
					const gchar* _tmp150_;
					sqlite3_stmt* _tmp153_;
					ZeitgeistSQLiteTableLookup* _tmp154_;
					ZeitgeistEvent* _tmp155_;
					const gchar* _tmp156_;
					const gchar* _tmp157_;
					sqlite3_stmt* _tmp160_;
					gint _tmp161_;
					gint _tmp162_;
					sqlite3_stmt* _tmp171_;
					gint _tmp172_;
					_tmp121_ = rc;
					if (_tmp121_ != SQLITE_CONSTRAINT) {
						ZeitgeistSQLiteDatabase* _tmp122_;
						ZeitgeistSQLiteDatabase* _tmp123_;
						gint _tmp124_;
						gint _tmp127_;
						sqlite3* _tmp128_;
						const gchar* _tmp129_;
						_tmp122_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
						_tmp123_ = _tmp122_;
						_tmp124_ = rc;
						zeitgeist_sq_lite_database_assert_not_corrupt (_tmp123_, _tmp124_, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								guint32 _tmp125_ = 0U;
								g_propagate_error (error, _inner_error_);
								return _tmp125_;
							} else {
								guint32 _tmp126_ = 0U;
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return _tmp126_;
							}
						}
						_tmp127_ = rc;
						_tmp128_ = ((ZeitgeistDbReader*) self)->db;
						_tmp129_ = sqlite3_errmsg (_tmp128_);
						g_warning ("engine.vala:330: SQL error: %d, %s\n", _tmp127_, _tmp129_);
						result = (guint32) 0;
						return result;
					}
					_tmp130_ = self->priv->last_id;
					self->priv->last_id = _tmp130_ - 1;
					_tmp131_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
					_tmp132_ = _tmp131_;
					_tmp133_ = _tmp132_->id_retrieval_stmt;
					retrieval_stmt = _tmp133_;
					_tmp134_ = retrieval_stmt;
					sqlite3_reset (_tmp134_);
					_tmp135_ = retrieval_stmt;
					_tmp136_ = event;
					_tmp137_ = zeitgeist_event_get_timestamp (_tmp136_);
					_tmp138_ = _tmp137_;
					sqlite3_bind_int64 (_tmp135_, 1, _tmp138_);
					_tmp139_ = retrieval_stmt;
					_tmp140_ = ((ZeitgeistDbReader*) self)->interpretations_table;
					_tmp141_ = event;
					_tmp142_ = zeitgeist_event_get_interpretation (_tmp141_);
					_tmp143_ = _tmp142_;
					zeitgeist_engine_bind_cached_reference (self, _tmp139_, 2, _tmp140_, _tmp143_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							guint32 _tmp144_ = 0U;
							g_propagate_error (error, _inner_error_);
							return _tmp144_;
						} else {
							guint32 _tmp145_ = 0U;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return _tmp145_;
						}
					}
					_tmp146_ = retrieval_stmt;
					_tmp147_ = ((ZeitgeistDbReader*) self)->manifestations_table;
					_tmp148_ = event;
					_tmp149_ = zeitgeist_event_get_manifestation (_tmp148_);
					_tmp150_ = _tmp149_;
					zeitgeist_engine_bind_cached_reference (self, _tmp146_, 3, _tmp147_, _tmp150_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							guint32 _tmp151_ = 0U;
							g_propagate_error (error, _inner_error_);
							return _tmp151_;
						} else {
							guint32 _tmp152_ = 0U;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return _tmp152_;
						}
					}
					_tmp153_ = retrieval_stmt;
					_tmp154_ = ((ZeitgeistDbReader*) self)->actors_table;
					_tmp155_ = event;
					_tmp156_ = zeitgeist_event_get_actor (_tmp155_);
					_tmp157_ = _tmp156_;
					zeitgeist_engine_bind_cached_reference (self, _tmp153_, 4, _tmp154_, _tmp157_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							guint32 _tmp158_ = 0U;
							g_propagate_error (error, _inner_error_);
							return _tmp158_;
						} else {
							guint32 _tmp159_ = 0U;
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return _tmp159_;
						}
					}
					_tmp160_ = retrieval_stmt;
					_tmp161_ = sqlite3_step (_tmp160_);
					rc = _tmp161_;
					_tmp162_ = rc;
					if (_tmp162_ != SQLITE_ROW) {
						ZeitgeistSQLiteDatabase* _tmp163_;
						ZeitgeistSQLiteDatabase* _tmp164_;
						gint _tmp165_;
						gint _tmp168_;
						sqlite3* _tmp169_;
						const gchar* _tmp170_;
						_tmp163_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
						_tmp164_ = _tmp163_;
						_tmp165_ = rc;
						zeitgeist_sq_lite_database_assert_not_corrupt (_tmp164_, _tmp165_, &_inner_error_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
								guint32 _tmp166_ = 0U;
								g_propagate_error (error, _inner_error_);
								return _tmp166_;
							} else {
								guint32 _tmp167_ = 0U;
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return _tmp167_;
							}
						}
						_tmp168_ = rc;
						_tmp169_ = ((ZeitgeistDbReader*) self)->db;
						_tmp170_ = sqlite3_errmsg (_tmp169_);
						g_warning ("engine.vala:352: SQL error: %d, %s\n", _tmp168_, _tmp170_);
						result = (guint32) 0;
						return result;
					}
					_tmp171_ = retrieval_stmt;
					_tmp172_ = sqlite3_column_int (_tmp171_, 0);
					result = (guint32) _tmp172_;
					return result;
				}
			}
		}
	}
	_tmp173_ = event;
	_tmp174_ = zeitgeist_event_get_interpretation (_tmp173_);
	_tmp175_ = _tmp174_;
	if (g_strcmp0 (_tmp175_, ZEITGEIST_ZG_MOVE_EVENT) == 0) {
		ZeitgeistEvent* _tmp176_;
		_tmp176_ = event;
		zeitgeist_engine_handle_move_event (self, _tmp176_);
	}
	_tmp177_ = event;
	_tmp178_ = zeitgeist_event_get_id (_tmp177_);
	_tmp179_ = _tmp178_;
	if ((_tmp179_ % 1000) == ((guint32) 0)) {
		ZeitgeistSQLiteDatabase* _tmp180_;
		ZeitgeistSQLiteDatabase* _tmp181_;
		_tmp180_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp181_ = _tmp180_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, (GSourceFunc) zeitgeist_sq_lite_database_analyze, g_object_ref (_tmp181_), g_object_unref);
	}
	_tmp182_ = event;
	_tmp183_ = zeitgeist_event_get_id (_tmp182_);
	_tmp184_ = _tmp183_;
	result = _tmp184_;
	return result;
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar* * errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_;
	sqlite3_callback _tmp1_;
	void* _tmp1__target;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp0_ = sql;
	_tmp1_ = callback;
	_tmp1__target = callback_target;
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
	sqlite_errmsg = _tmp2_;
	ec = _tmp3_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = sqlite_errmsg;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp5_;
	}
	_tmp6_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp6_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}


ZeitgeistTimeRange* zeitgeist_engine_delete_events (ZeitgeistEngine* self, guint32* event_ids, int event_ids_length1, const char* sender, GError** error) {
	ZeitgeistTimeRange* result = NULL;
	guint32* _tmp0_;
	gint _tmp0__length1;
	ZeitgeistExtensionCollection* _tmp1_;
	guint32* _tmp2_;
	gint _tmp2__length1;
	const char* _tmp3_;
	gint _tmp4_;
	guint32* _tmp5_;
	ZeitgeistTimeRange* time_range = NULL;
	ZeitgeistSQLiteDatabase* _tmp6_;
	ZeitgeistSQLiteDatabase* _tmp7_;
	guint32* _tmp8_;
	gint _tmp8__length1;
	ZeitgeistTimeRange* _tmp9_;
	gchar* sql_event_ids = NULL;
	ZeitgeistSQLiteDatabase* _tmp10_;
	ZeitgeistSQLiteDatabase* _tmp11_;
	guint32* _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	ZeitgeistTimeRange* _tmp14_;
	gint rc = 0;
	sqlite3* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	ZeitgeistSQLiteDatabase* _tmp24_;
	ZeitgeistSQLiteDatabase* _tmp25_;
	gint _tmp26_;
	sqlite3* _tmp27_;
	gint _tmp28_;
	guint32* _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ZeitgeistExtensionCollection* _tmp32_;
	guint32* _tmp33_;
	gint _tmp33__length1;
	const char* _tmp34_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = event_ids;
	_tmp0__length1 = event_ids_length1;
	_vala_return_val_if_fail (_tmp0__length1 > 0, "event_ids.length > 0", NULL);
	_tmp1_ = self->priv->extension_collection;
	_tmp2_ = event_ids;
	_tmp2__length1 = event_ids_length1;
	_tmp3_ = sender;
	_tmp5_ = zeitgeist_extension_collection_call_pre_delete_events (_tmp1_, _tmp2_, _tmp2__length1, _tmp3_, &_tmp4_);
	event_ids = _tmp5_;
	event_ids_length1 = _tmp4_;
	_tmp6_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = event_ids;
	_tmp8__length1 = event_ids_length1;
	_tmp9_ = zeitgeist_sq_lite_database_get_time_range_for_event_ids (_tmp7_, _tmp8_, _tmp8__length1, &_inner_error_);
	time_range = _tmp9_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = event_ids;
	_tmp12__length1 = event_ids_length1;
	_tmp13_ = zeitgeist_sq_lite_database_get_sql_string_from_event_ids (_tmp11_, _tmp12_, _tmp12__length1);
	sql_event_ids = _tmp13_;
	_tmp14_ = time_range;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp15_ = sql_event_ids;
		_tmp16_ = g_strdup_printf ("Tried to delete non-existing event(s): %s", _tmp15_);
		_tmp17_ = _tmp16_;
		g_warning ("engine.vala:385: %s", _tmp17_);
		_g_free0 (_tmp17_);
		result = NULL;
		_g_free0 (sql_event_ids);
		_g_object_unref0 (time_range);
		return result;
	}
	_tmp18_ = ((ZeitgeistDbReader*) self)->db;
	_tmp19_ = sql_event_ids;
	_tmp20_ = g_strdup_printf ("DELETE FROM event WHERE id IN (%s)", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _sqlite3_exec (_tmp18_, _tmp21_, NULL, NULL, NULL);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	rc = _tmp23_;
	_tmp24_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = rc;
	zeitgeist_sq_lite_database_assert_query_success (_tmp25_, _tmp26_, "engine.vala:392: SQL Error", SQLITE_OK, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			return NULL;
		} else {
			_g_free0 (sql_event_ids);
			_g_object_unref0 (time_range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = ((ZeitgeistDbReader*) self)->db;
	_tmp28_ = sqlite3_changes (_tmp27_);
	_tmp29_ = event_ids;
	_tmp29__length1 = event_ids_length1;
	_tmp30_ = g_strdup_printf ("Deleted %d (out of %d) events.", _tmp28_, _tmp29__length1);
	_tmp31_ = _tmp30_;
	g_message ("engine.vala:393: %s", _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = self->priv->extension_collection;
	_tmp33_ = event_ids;
	_tmp33__length1 = event_ids_length1;
	_tmp34_ = sender;
	zeitgeist_extension_collection_call_post_delete_events (_tmp32_, _tmp33_, _tmp33__length1, _tmp34_);
	result = time_range;
	_g_free0 (sql_event_ids);
	return result;
}


/**
     * Clear all resources Engine is using (close database connection,
     * unload extensions, etc.).
     *
     * After executing this method on an Engine instance, no other function
     * of said instance may be called.
     */
static void zeitgeist_engine_real_close (ZeitgeistDbReader* base) {
	ZeitgeistEngine * self;
	self = (ZeitgeistEngine*) base;
	_g_object_unref0 (self->priv->extension_collection);
	self->priv->extension_collection = NULL;
	ZEITGEIST_DB_READER_CLASS (zeitgeist_engine_parent_class)->close (G_TYPE_CHECK_INSTANCE_CAST (self, ZEITGEIST_TYPE_DB_READER, ZeitgeistDbReader));
}


static void zeitgeist_engine_handle_move_event (ZeitgeistEngine* self, ZeitgeistEvent* event) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ZeitgeistEvent* _tmp3_;
				GPtrArray* _tmp4_;
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				ZeitgeistSubject* subject = NULL;
				ZeitgeistEvent* _tmp8_;
				GPtrArray* _tmp9_;
				GPtrArray* _tmp10_;
				gint _tmp11_;
				gconstpointer _tmp12_;
				ZeitgeistSubject* _tmp13_;
				gint rc = 0;
				sqlite3_stmt* move_stmt = NULL;
				ZeitgeistSQLiteDatabase* _tmp14_;
				ZeitgeistSQLiteDatabase* _tmp15_;
				sqlite3_stmt* _tmp16_;
				sqlite3_stmt* _tmp17_;
				sqlite3_stmt* _tmp18_;
				ZeitgeistSubject* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				GDestroyNotify _tmp23_;
				sqlite3_stmt* _tmp24_;
				ZeitgeistSubject* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				GDestroyNotify _tmp29_;
				sqlite3_stmt* _tmp30_;
				ZeitgeistSubject* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				GDestroyNotify _tmp35_;
				sqlite3_stmt* _tmp36_;
				ZeitgeistEvent* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				GDestroyNotify _tmp41_;
				sqlite3_stmt* _tmp42_;
				ZeitgeistEvent* _tmp43_;
				gint64 _tmp44_;
				gint64 _tmp45_;
				sqlite3_stmt* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = event;
				_tmp4_ = zeitgeist_event_get_subjects (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp2_ < _tmp7_)) {
					break;
				}
				_tmp8_ = event;
				_tmp9_ = zeitgeist_event_get_subjects (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				_tmp13_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp12_);
				subject = _tmp13_;
				_tmp14_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_->move_handling_stmt;
				move_stmt = _tmp16_;
				_tmp17_ = move_stmt;
				sqlite3_reset (_tmp17_);
				_tmp18_ = move_stmt;
				_tmp19_ = subject;
				_tmp20_ = zeitgeist_subject_get_current_uri (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup (_tmp21_);
				_tmp23_ = g_free;
				sqlite3_bind_text (_tmp18_, 1, _tmp22_, -1, _tmp23_);
				_tmp24_ = move_stmt;
				_tmp25_ = subject;
				_tmp26_ = zeitgeist_subject_get_current_origin (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_strdup (_tmp27_);
				_tmp29_ = g_free;
				sqlite3_bind_text (_tmp24_, 2, _tmp28_, -1, _tmp29_);
				_tmp30_ = move_stmt;
				_tmp31_ = subject;
				_tmp32_ = zeitgeist_subject_get_uri (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strdup (_tmp33_);
				_tmp35_ = g_free;
				sqlite3_bind_text (_tmp30_, 3, _tmp34_, -1, _tmp35_);
				_tmp36_ = move_stmt;
				_tmp37_ = event;
				_tmp38_ = zeitgeist_event_get_interpretation (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strdup (_tmp39_);
				_tmp41_ = g_free;
				sqlite3_bind_text (_tmp36_, 4, _tmp40_, -1, _tmp41_);
				_tmp42_ = move_stmt;
				_tmp43_ = event;
				_tmp44_ = zeitgeist_event_get_timestamp (_tmp43_);
				_tmp45_ = _tmp44_;
				sqlite3_bind_int64 (_tmp42_, 5, _tmp45_);
				_tmp46_ = move_stmt;
				_tmp47_ = sqlite3_step (_tmp46_);
				rc = _tmp47_;
				_tmp48_ = rc;
				if (_tmp48_ != SQLITE_DONE) {
					gint _tmp49_;
					_tmp49_ = rc;
					if (_tmp49_ != SQLITE_CONSTRAINT) {
						gint _tmp53_;
						sqlite3* _tmp54_;
						const gchar* _tmp55_;
						{
							ZeitgeistSQLiteDatabase* _tmp50_;
							ZeitgeistSQLiteDatabase* _tmp51_;
							gint _tmp52_;
							_tmp50_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
							_tmp51_ = _tmp50_;
							_tmp52_ = rc;
							zeitgeist_sq_lite_database_assert_not_corrupt (_tmp51_, _tmp52_, &_inner_error_);
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
									goto __catch1_zeitgeist_engine_error;
								}
								_g_object_unref0 (subject);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						goto __finally1;
						__catch1_zeitgeist_engine_error:
						{
							GError* err = NULL;
							err = _inner_error_;
							_inner_error_ = NULL;
							_g_error_free0 (err);
						}
						__finally1:
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							_g_object_unref0 (subject);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
						_tmp53_ = rc;
						_tmp54_ = ((ZeitgeistDbReader*) self)->db;
						_tmp55_ = sqlite3_errmsg (_tmp54_);
						g_warning ("engine.vala:439: SQL error: %d, %s\n", _tmp53_, _tmp55_);
					}
				}
				_g_object_unref0 (subject);
			}
		}
	}
}


static gint64 zeitgeist_engine_store_payload (ZeitgeistEngine* self, ZeitgeistEvent* event) {
	gint64 result = 0LL;
	ZeitgeistEvent* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (event != NULL, 0LL);
	_tmp0_ = event;
	_tmp1_ = zeitgeist_event_get_payload (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gint rc = 0;
		sqlite3_stmt* payload_insertion_stmt = NULL;
		ZeitgeistSQLiteDatabase* _tmp3_;
		ZeitgeistSQLiteDatabase* _tmp4_;
		sqlite3_stmt* _tmp5_;
		sqlite3_stmt* _tmp6_;
		sqlite3_stmt* _tmp7_;
		ZeitgeistEvent* _tmp8_;
		GByteArray* _tmp9_;
		GByteArray* _tmp10_;
		guint8* _tmp11_;
		gint _tmp11__length1;
		ZeitgeistEvent* _tmp12_;
		GByteArray* _tmp13_;
		GByteArray* _tmp14_;
		guint8* _tmp15_;
		gint _tmp15__length1;
		sqlite3_stmt* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		ZeitgeistSQLiteDatabase* _tmp28_;
		ZeitgeistSQLiteDatabase* _tmp29_;
		sqlite3* _tmp30_;
		gint64 _tmp31_;
		_tmp3_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_->payload_insertion_stmt;
		payload_insertion_stmt = _tmp5_;
		_tmp6_ = payload_insertion_stmt;
		sqlite3_reset (_tmp6_);
		_tmp7_ = payload_insertion_stmt;
		_tmp8_ = event;
		_tmp9_ = zeitgeist_event_get_payload (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->data;
		_tmp11__length1 = (gint) _tmp10_->len;
		_tmp12_ = event;
		_tmp13_ = zeitgeist_event_get_payload (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->data;
		_tmp15__length1 = (gint) _tmp14_->len;
		sqlite3_bind_blob (_tmp7_, 1, _tmp11_, _tmp15__length1, NULL);
		_tmp16_ = payload_insertion_stmt;
		_tmp17_ = sqlite3_step (_tmp16_);
		rc = _tmp17_;
		_tmp18_ = rc;
		if (_tmp18_ != SQLITE_DONE) {
			gint _tmp19_;
			_tmp19_ = rc;
			if (_tmp19_ != SQLITE_CONSTRAINT) {
				gint _tmp20_;
				sqlite3* _tmp21_;
				const gchar* _tmp22_;
				_tmp20_ = rc;
				_tmp21_ = ((ZeitgeistDbReader*) self)->db;
				_tmp22_ = sqlite3_errmsg (_tmp21_);
				g_warning ("engine.vala:464: SQL error: %d, %s\n", _tmp20_, _tmp22_);
				{
					ZeitgeistSQLiteDatabase* _tmp23_;
					ZeitgeistSQLiteDatabase* _tmp24_;
					gint _tmp25_;
					_tmp23_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
					_tmp24_ = _tmp23_;
					_tmp25_ = rc;
					zeitgeist_sq_lite_database_assert_not_corrupt (_tmp24_, _tmp25_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gint64 _tmp26_ = 0LL;
						if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
							goto __catch2_zeitgeist_engine_error;
						}
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp26_;
					}
				}
				goto __finally2;
				__catch2_zeitgeist_engine_error:
				{
					GError* err = NULL;
					err = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (err);
				}
				__finally2:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gint64 _tmp27_ = 0LL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp27_;
				}
			}
		}
		_tmp28_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->database;
		_tmp31_ = sqlite3_last_insert_rowid (_tmp30_);
		result = _tmp31_;
		return result;
	}
	result = (gint64) 0;
	return result;
}


static GObject * zeitgeist_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistEngine * self;
	ZeitgeistExtensionStore* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	ZeitgeistSQLiteDatabase* _tmp2_;
	parent_class = G_OBJECT_CLASS (zeitgeist_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine);
	_tmp0_ = zeitgeist_extension_store_new (self);
	_g_object_unref0 (self->extension_store);
	self->extension_store = _tmp0_;
	_tmp1_ = zeitgeist_db_reader_get_database ((ZeitgeistDbReader*) self);
	_tmp2_ = _tmp1_;
	zeitgeist_sq_lite_database_set_cache_size (_tmp2_, 24);
	return obj;
}


static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_construct (GType object_type, ZeitgeistSQLiteDatabase* db, const gchar* data_type) {
	ZeitgeistEngineDataInserter* self = NULL;
	ZeitgeistSQLiteDatabase* _tmp0_;
	ZeitgeistSQLiteDatabase* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GPtrArray* _tmp4_;
	g_return_val_if_fail (db != NULL, NULL);
	g_return_val_if_fail (data_type != NULL, NULL);
	self = (ZeitgeistEngineDataInserter*) g_type_create_instance (object_type);
	_tmp0_ = db;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp1_;
	_tmp2_ = data_type;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->type);
	self->priv->type = _tmp3_;
	_tmp4_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
	_g_ptr_array_unref0 (self->priv->data);
	self->priv->data = _tmp4_;
	return self;
}


static ZeitgeistEngineDataInserter* zeitgeist_engine_data_inserter_new (ZeitgeistSQLiteDatabase* db, const gchar* data_type) {
	return zeitgeist_engine_data_inserter_construct (ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, db, data_type);
}


static void zeitgeist_engine_data_inserter_add (ZeitgeistEngineDataInserter* self, const gchar* val, GError** error) {
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GPtrArray* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = self->priv->data;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ZEITGEIST_ENGINE_DATA_INSERTER_MAX_PARAMETERS) {
		zeitgeist_engine_data_inserter_flush (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp3_ = self->priv->data;
	_tmp4_ = val;
	_tmp5_ = g_strdup (_tmp4_);
	g_ptr_array_add (_tmp3_, _tmp5_);
}


static void zeitgeist_engine_data_inserter_flush (ZeitgeistEngineDataInserter* self, GError** error) {
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->data;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		ZeitgeistSQLiteDatabase* _tmp3_;
		const gchar* _tmp4_;
		GPtrArray* _tmp5_;
		GPtrArray* _tmp6_;
		_tmp3_ = self->priv->database;
		_tmp4_ = self->priv->type;
		_tmp5_ = self->priv->data;
		zeitgeist_sq_lite_database_insert_or_ignore_into_table (_tmp3_, _tmp4_, _tmp5_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == ZEITGEIST_ENGINE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp6_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (self->priv->data);
		self->priv->data = _tmp6_;
	}
}


static void zeitgeist_engine_value_data_inserter_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void zeitgeist_engine_value_data_inserter_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		zeitgeist_engine_data_inserter_unref (value->data[0].v_pointer);
	}
}


static void zeitgeist_engine_value_data_inserter_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = zeitgeist_engine_data_inserter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer zeitgeist_engine_value_data_inserter_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* zeitgeist_engine_value_data_inserter_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ZeitgeistEngineDataInserter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = zeitgeist_engine_data_inserter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* zeitgeist_engine_value_data_inserter_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ZeitgeistEngineDataInserter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = zeitgeist_engine_data_inserter_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* zeitgeist_engine_param_spec_data_inserter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ZeitgeistEngineParamSpecDataInserter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer zeitgeist_engine_value_get_data_inserter (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER), NULL);
	return value->data[0].v_pointer;
}


static void zeitgeist_engine_value_set_data_inserter (GValue* value, gpointer v_object) {
	ZeitgeistEngineDataInserter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		zeitgeist_engine_data_inserter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_engine_data_inserter_unref (old);
	}
}


static void zeitgeist_engine_value_take_data_inserter (GValue* value, gpointer v_object) {
	ZeitgeistEngineDataInserter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		zeitgeist_engine_data_inserter_unref (old);
	}
}


static void zeitgeist_engine_data_inserter_class_init (ZeitgeistEngineDataInserterClass * klass) {
	zeitgeist_engine_data_inserter_parent_class = g_type_class_peek_parent (klass);
	((ZeitgeistEngineDataInserterClass *) klass)->finalize = zeitgeist_engine_data_inserter_finalize;
	g_type_class_add_private (klass, sizeof (ZeitgeistEngineDataInserterPrivate));
}


static void zeitgeist_engine_data_inserter_instance_init (ZeitgeistEngineDataInserter * self) {
	self->priv = ZEITGEIST_ENGINE_DATA_INSERTER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void zeitgeist_engine_data_inserter_finalize (ZeitgeistEngineDataInserter * obj) {
	ZeitgeistEngineDataInserter * self;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_ENGINE_TYPE_DATA_INSERTER, ZeitgeistEngineDataInserter);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->data;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		g_warning ("engine.vala:200: DataInserter: destroyed with unflushed data");
	}
	_g_object_unref0 (self->priv->database);
	_g_free0 (self->priv->type);
	_g_ptr_array_unref0 (self->priv->data);
}


static GType zeitgeist_engine_data_inserter_get_type (void) {
	static volatile gsize zeitgeist_engine_data_inserter_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_engine_data_inserter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { zeitgeist_engine_value_data_inserter_init, zeitgeist_engine_value_data_inserter_free_value, zeitgeist_engine_value_data_inserter_copy_value, zeitgeist_engine_value_data_inserter_peek_pointer, "p", zeitgeist_engine_value_data_inserter_collect_value, "p", zeitgeist_engine_value_data_inserter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEngineDataInserterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_engine_data_inserter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEngineDataInserter), 0, (GInstanceInitFunc) zeitgeist_engine_data_inserter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType zeitgeist_engine_data_inserter_type_id;
		zeitgeist_engine_data_inserter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ZeitgeistEngineDataInserter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&zeitgeist_engine_data_inserter_type_id__volatile, zeitgeist_engine_data_inserter_type_id);
	}
	return zeitgeist_engine_data_inserter_type_id__volatile;
}


static gpointer zeitgeist_engine_data_inserter_ref (gpointer instance) {
	ZeitgeistEngineDataInserter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void zeitgeist_engine_data_inserter_unref (gpointer instance) {
	ZeitgeistEngineDataInserter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ZEITGEIST_ENGINE_DATA_INSERTER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void zeitgeist_engine_class_init (ZeitgeistEngineClass * klass) {
	zeitgeist_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistEnginePrivate));
	((ZeitgeistDbReaderClass *) klass)->close = (void (*) (ZeitgeistDbReader *)) zeitgeist_engine_real_close;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_engine_finalize;
}


static void zeitgeist_engine_instance_init (ZeitgeistEngine * self) {
	self->priv = ZEITGEIST_ENGINE_GET_PRIVATE (self);
}


static void zeitgeist_engine_finalize (GObject * obj) {
	ZeitgeistEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine);
	_g_object_unref0 (self->extension_store);
	_g_object_unref0 (self->priv->extension_collection);
	G_OBJECT_CLASS (zeitgeist_engine_parent_class)->finalize (obj);
}


GType zeitgeist_engine_get_type (void) {
	static volatile gsize zeitgeist_engine_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEngine), 0, (GInstanceInitFunc) zeitgeist_engine_instance_init, NULL };
		GType zeitgeist_engine_type_id;
		zeitgeist_engine_type_id = g_type_register_static (ZEITGEIST_TYPE_DB_READER, "ZeitgeistEngine", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_engine_type_id__volatile, zeitgeist_engine_type_id);
	}
	return zeitgeist_engine_type_id__volatile;
}



