/* extension-collection.c generated by valac 0.38.8, the Vala compiler
 * generated from extension-collection.vala, do not modify */

/* extension-collection.vala
 *
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "zeitgeist-internal.h"
#include "zeitgeist-datamodel.h"
#include <glib/gstdio.h>
#include <gmodule.h>


#define ZEITGEIST_TYPE_EXTENSION_COLLECTION (zeitgeist_extension_collection_get_type ())
#define ZEITGEIST_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection))
#define ZEITGEIST_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))
#define ZEITGEIST_IS_EXTENSION_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_IS_EXTENSION_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_COLLECTION))
#define ZEITGEIST_EXTENSION_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionClass))

typedef struct _ZeitgeistExtensionCollection ZeitgeistExtensionCollection;
typedef struct _ZeitgeistExtensionCollectionClass ZeitgeistExtensionCollectionClass;
typedef struct _ZeitgeistExtensionCollectionPrivate ZeitgeistExtensionCollectionPrivate;

#define ZEITGEIST_TYPE_EXTENSION (zeitgeist_extension_get_type ())
#define ZEITGEIST_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtension))
#define ZEITGEIST_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtensionClass))
#define ZEITGEIST_IS_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION))
#define ZEITGEIST_IS_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION))
#define ZEITGEIST_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION, ZeitgeistExtensionClass))

typedef struct _ZeitgeistExtension ZeitgeistExtension;
typedef struct _ZeitgeistExtensionClass ZeitgeistExtensionClass;

#define ZEITGEIST_TYPE_ENGINE (zeitgeist_engine_get_type ())
#define ZEITGEIST_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngine))
#define ZEITGEIST_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))
#define ZEITGEIST_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_ENGINE))
#define ZEITGEIST_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_ENGINE, ZeitgeistEngineClass))

typedef struct _ZeitgeistEngine ZeitgeistEngine;
typedef struct _ZeitgeistEngineClass ZeitgeistEngineClass;
enum  {
	ZEITGEIST_EXTENSION_COLLECTION_0_PROPERTY,
	ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY,
	ZEITGEIST_EXTENSION_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_extension_collection_properties[ZEITGEIST_EXTENSION_COLLECTION_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define ZEITGEIST_TYPE_EXTENSION_LOADER (zeitgeist_extension_loader_get_type ())
#define ZEITGEIST_EXTENSION_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoader))
#define ZEITGEIST_EXTENSION_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoaderClass))
#define ZEITGEIST_IS_EXTENSION_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER))
#define ZEITGEIST_IS_EXTENSION_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EXTENSION_LOADER))
#define ZEITGEIST_EXTENSION_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EXTENSION_LOADER, ZeitgeistExtensionLoaderClass))

typedef struct _ZeitgeistExtensionLoader ZeitgeistExtensionLoader;
typedef struct _ZeitgeistExtensionLoaderClass ZeitgeistExtensionLoaderClass;

#define ZEITGEIST_TYPE_BUILTIN_EXTENSION (zeitgeist_builtin_extension_get_type ())
#define ZEITGEIST_BUILTIN_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtension))
#define ZEITGEIST_BUILTIN_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtensionClass))
#define ZEITGEIST_IS_BUILTIN_EXTENSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION))
#define ZEITGEIST_IS_BUILTIN_EXTENSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_BUILTIN_EXTENSION))
#define ZEITGEIST_BUILTIN_EXTENSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_BUILTIN_EXTENSION, ZeitgeistBuiltinExtensionClass))

typedef struct _ZeitgeistBuiltinExtension ZeitgeistBuiltinExtension;
typedef struct _ZeitgeistBuiltinExtensionClass ZeitgeistBuiltinExtensionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZEITGEIST_TYPE_MODULE_LOADER (zeitgeist_module_loader_get_type ())
#define ZEITGEIST_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoader))
#define ZEITGEIST_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoaderClass))
#define ZEITGEIST_IS_MODULE_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_MODULE_LOADER))
#define ZEITGEIST_IS_MODULE_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_MODULE_LOADER))
#define ZEITGEIST_MODULE_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_MODULE_LOADER, ZeitgeistModuleLoaderClass))

typedef struct _ZeitgeistModuleLoader ZeitgeistModuleLoader;
typedef struct _ZeitgeistModuleLoaderClass ZeitgeistModuleLoaderClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistExtensionCollection {
	GObject parent_instance;
	ZeitgeistExtensionCollectionPrivate * priv;
};

struct _ZeitgeistExtensionCollectionClass {
	GObjectClass parent_class;
};

struct _ZeitgeistExtensionCollectionPrivate {
	GPtrArray* extensions;
	gchar** disabled_extensions;
	gint disabled_extensions_length1;
	gint _disabled_extensions_size_;
	ZeitgeistEngine* _engine;
};

typedef GType (*ZeitgeistRegisterExtensionFunc) (GTypeModule* module);

static gpointer zeitgeist_extension_collection_parent_class = NULL;

GType zeitgeist_extension_collection_get_type (void) G_GNUC_CONST;
GType zeitgeist_extension_get_type (void) G_GNUC_CONST;
GType zeitgeist_engine_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EXTENSION_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollectionPrivate))
static void _zeitgeist_extension_collection___lambda4_ (ZeitgeistExtensionCollection* self, ZeitgeistExtension* ext);
void zeitgeist_extension_unload (ZeitgeistExtension* self);
static void __zeitgeist_extension_collection___lambda4__gfunc (gconstpointer data, gpointer self);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1);
ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1);
static void zeitgeist_extension_collection_setup (ZeitgeistExtensionCollection* self, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1);
static void _g_object_unref0_ (gpointer var);
GType zeitgeist_extension_loader_get_type (void) G_GNUC_CONST;
ZeitgeistBuiltinExtension* zeitgeist_builtin_extension_new (ZeitgeistRegisterExtensionFunc func);
ZeitgeistBuiltinExtension* zeitgeist_builtin_extension_construct (GType object_type, ZeitgeistRegisterExtensionFunc func);
GType zeitgeist_builtin_extension_get_type (void) G_GNUC_CONST;
static ZeitgeistExtension* zeitgeist_extension_collection_instantiate_extension (ZeitgeistExtensionCollection* self, ZeitgeistExtensionLoader* loader);
GType zeitgeist_module_loader_get_type (void) G_GNUC_CONST;
ZeitgeistModuleLoader* zeitgeist_module_loader_new (const gchar* module_path);
ZeitgeistModuleLoader* zeitgeist_module_loader_construct (GType object_type, const gchar* module_path);
GType zeitgeist_extension_loader_get_extension_type (ZeitgeistExtensionLoader* self);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
ZeitgeistExtension* zeitgeist_extension_loader_create_instance (ZeitgeistExtensionLoader* self, ZeitgeistEngine* engine);
ZeitgeistEngine* zeitgeist_extension_collection_get_engine (ZeitgeistExtensionCollection* self);
gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value);
void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
void zeitgeist_extension_pre_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender);
void zeitgeist_extension_post_insert_events (ZeitgeistExtension* self, GPtrArray* events, const char* sender);
guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1);
guint32* zeitgeist_extension_pre_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender, int* result_length1);
void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender);
void zeitgeist_extension_post_delete_events (ZeitgeistExtension* self, guint32* ids, int ids_length1, const char* sender);
static void zeitgeist_extension_collection_set_engine (ZeitgeistExtensionCollection* self, ZeitgeistEngine* value);
static void zeitgeist_extension_collection_finalize (GObject * obj);
static void _vala_zeitgeist_extension_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_extension_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _zeitgeist_extension_collection___lambda4_ (ZeitgeistExtensionCollection* self, ZeitgeistExtension* ext) {
	ZeitgeistExtension* _tmp0_;
	g_return_if_fail (ext != NULL);
	_tmp0_ = ext;
	zeitgeist_extension_unload (_tmp0_);
}


static void __zeitgeist_extension_collection___lambda4__gfunc (gconstpointer data, gpointer self) {
	_zeitgeist_extension_collection___lambda4_ ((ZeitgeistExtensionCollection*) self, (ZeitgeistExtension*) data);
}


ZeitgeistExtensionCollection* zeitgeist_extension_collection_construct (GType object_type, ZeitgeistEngine* engine, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1) {
	ZeitgeistExtensionCollection * self = NULL;
	ZeitgeistEngine* _tmp0_;
	ZeitgeistRegisterExtensionFunc* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (engine != NULL, NULL);
	_tmp0_ = engine;
	self = (ZeitgeistExtensionCollection*) g_object_new (object_type, "engine", _tmp0_, NULL);
	_tmp1_ = builtins;
	_tmp1__length1 = builtins_length1;
	zeitgeist_extension_collection_setup (self, _tmp1_, _tmp1__length1);
	return self;
}


ZeitgeistExtensionCollection* zeitgeist_extension_collection_new (ZeitgeistEngine* engine, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1) {
	return zeitgeist_extension_collection_construct (ZEITGEIST_TYPE_EXTENSION_COLLECTION, engine, builtins, builtins_length1);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void zeitgeist_extension_collection_setup (ZeitgeistExtensionCollection* self, ZeitgeistRegisterExtensionFunc* builtins, int builtins_length1) {
	ZeitgeistExtension* extension = NULL;
	GPtrArray* _tmp0_;
	const gchar* disabled = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ZeitgeistRegisterExtensionFunc* _tmp6_;
	gint _tmp6__length1;
	const gchar* ext_dir1 = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	GDir* user_ext_dir = NULL;
	GDir* _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->extensions);
	self->priv->extensions = _tmp0_;
	_tmp1_ = g_getenv ("ZEITGEIST_DISABLED_EXTENSIONS");
	disabled = _tmp1_;
	_tmp2_ = disabled;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar** _tmp4_;
		gchar** _tmp5_;
		_tmp3_ = disabled;
		_tmp5_ = _tmp4_ = g_strsplit_set (_tmp3_, ",:;", 0);
		self->priv->disabled_extensions = (_vala_array_free (self->priv->disabled_extensions, self->priv->disabled_extensions_length1, (GDestroyNotify) g_free), NULL);
		self->priv->disabled_extensions = _tmp5_;
		self->priv->disabled_extensions_length1 = _vala_array_length (_tmp4_);
		self->priv->_disabled_extensions_size_ = self->priv->disabled_extensions_length1;
	}
	_tmp6_ = builtins;
	_tmp6__length1 = builtins_length1;
	{
		ZeitgeistRegisterExtensionFunc* func_collection = NULL;
		gint func_collection_length1 = 0;
		gint _func_collection_size_ = 0;
		gint func_it = 0;
		func_collection = _tmp6_;
		func_collection_length1 = _tmp6__length1;
		for (func_it = 0; func_it < _tmp6__length1; func_it = func_it + 1) {
			ZeitgeistRegisterExtensionFunc func = NULL;
			func = func_collection[func_it];
			{
				ZeitgeistExtensionLoader* builtin = NULL;
				ZeitgeistRegisterExtensionFunc _tmp7_;
				ZeitgeistBuiltinExtension* _tmp8_;
				ZeitgeistExtensionLoader* _tmp9_;
				ZeitgeistExtension* _tmp10_;
				ZeitgeistExtension* _tmp11_;
				_tmp7_ = func;
				_tmp8_ = zeitgeist_builtin_extension_new (_tmp7_);
				builtin = (ZeitgeistExtensionLoader*) _tmp8_;
				_tmp9_ = builtin;
				_tmp10_ = zeitgeist_extension_collection_instantiate_extension (self, _tmp9_);
				_g_object_unref0 (extension);
				extension = _tmp10_;
				_tmp11_ = extension;
				if (_tmp11_ != NULL) {
					GPtrArray* _tmp12_;
					ZeitgeistExtension* _tmp13_;
					ZeitgeistExtension* _tmp14_;
					_tmp12_ = self->priv->extensions;
					_tmp13_ = extension;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					g_ptr_array_add (_tmp12_, _tmp14_);
				}
				_g_object_unref0 (builtin);
			}
		}
	}
	_tmp15_ = zeitgeist_utils_get_local_extensions_path ();
	ext_dir1 = _tmp15_;
	_tmp16_ = ext_dir1;
	_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS);
	if (!_tmp17_) {
		_g_object_unref0 (extension);
		return;
	}
	user_ext_dir = NULL;
	{
		GDir* _tmp18_ = NULL;
		const gchar* _tmp19_;
		GDir* _tmp20_;
		GDir* _tmp21_;
		_tmp19_ = ext_dir1;
		_tmp20_ = g_dir_open (_tmp19_, (guint) 0, &_inner_error_);
		_tmp18_ = _tmp20_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp21_ = _tmp18_;
		_tmp18_ = NULL;
		_g_dir_close0 (user_ext_dir);
		user_ext_dir = _tmp21_;
		_g_dir_close0 (_tmp18_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_warning ("extension-collection.vala:72: Couldn't open local extensions directory" \
": %s", _tmp23_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_dir_close0 (user_ext_dir);
		_g_object_unref0 (extension);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp24_ = user_ext_dir;
	if (_tmp24_ != NULL) {
		const gchar* file_name = NULL;
		GDir* _tmp25_;
		const gchar* _tmp26_;
		_tmp25_ = user_ext_dir;
		_tmp26_ = g_dir_read_name (_tmp25_);
		file_name = _tmp26_;
		while (TRUE) {
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gboolean _tmp29_;
			GDir* _tmp44_;
			const gchar* _tmp45_;
			_tmp27_ = file_name;
			if (!(_tmp27_ != NULL)) {
				break;
			}
			_tmp28_ = file_name;
			_tmp29_ = g_str_has_suffix (_tmp28_, "." G_MODULE_SUFFIX);
			if (_tmp29_) {
				gchar* path = NULL;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				ZeitgeistModuleLoader* loader = NULL;
				const gchar* _tmp34_;
				ZeitgeistModuleLoader* _tmp35_;
				ZeitgeistModuleLoader* _tmp36_;
				ZeitgeistExtension* _tmp37_;
				ZeitgeistExtension* _tmp38_;
				_tmp30_ = ext_dir1;
				_tmp31_ = file_name;
				_tmp32_ = g_build_filename (_tmp30_, _tmp31_, NULL);
				path = _tmp32_;
				_tmp33_ = path;
				g_debug ("extension-collection.vala:83: Loading extension: \"%s\"", _tmp33_);
				_tmp34_ = path;
				_tmp35_ = zeitgeist_module_loader_new (_tmp34_);
				loader = _tmp35_;
				_tmp36_ = loader;
				_tmp37_ = zeitgeist_extension_collection_instantiate_extension (self, (ZeitgeistExtensionLoader*) _tmp36_);
				_g_object_unref0 (extension);
				extension = _tmp37_;
				_tmp38_ = extension;
				if (_tmp38_ != NULL) {
					GPtrArray* _tmp39_;
					ZeitgeistExtension* _tmp40_;
					ZeitgeistExtension* _tmp41_;
					_tmp39_ = self->priv->extensions;
					_tmp40_ = extension;
					_tmp41_ = _g_object_ref0 (_tmp40_);
					g_ptr_array_add (_tmp39_, _tmp41_);
				}
				_g_object_unref0 (loader);
				_g_free0 (path);
			} else {
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				_tmp42_ = ext_dir1;
				_tmp43_ = file_name;
				g_debug ("extension-collection.vala:90: Ignored file \"%s/%s\"", _tmp42_, _tmp43_);
			}
			_tmp44_ = user_ext_dir;
			_tmp45_ = g_dir_read_name (_tmp44_);
			file_name = _tmp45_;
		}
	}
	_g_dir_close0 (user_ext_dir);
	_g_object_unref0 (extension);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static ZeitgeistExtension* zeitgeist_extension_collection_instantiate_extension (ZeitgeistExtensionCollection* self, ZeitgeistExtensionLoader* loader) {
	ZeitgeistExtension* result = NULL;
	ZeitgeistExtensionLoader* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (loader != NULL, NULL);
	_tmp0_ = loader;
	_tmp1_ = g_type_module_use ((GTypeModule*) _tmp0_);
	if (_tmp1_) {
		const gchar* type_name = NULL;
		ZeitgeistExtensionLoader* _tmp2_;
		GType _tmp3_;
		GType _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gboolean _tmp8_;
		const gchar* _tmp10_;
		gboolean _tmp11_;
		gboolean enabled = FALSE;
		const gchar* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		gboolean _tmp20_;
		ZeitgeistExtension* _tmp22_ = NULL;
		gboolean _tmp23_;
		ZeitgeistExtension* e = NULL;
		ZeitgeistExtension* _tmp27_;
		ZeitgeistExtensionLoader* _tmp28_;
		_tmp2_ = loader;
		_tmp3_ = zeitgeist_extension_loader_get_extension_type (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_type_name (_tmp4_);
		type_name = _tmp5_;
		_tmp6_ = type_name;
		if (_tmp6_ == NULL) {
			result = NULL;
			return result;
		}
		_tmp7_ = type_name;
		_tmp8_ = g_str_has_prefix (_tmp7_, "Zeitgeist");
		if (_tmp8_) {
			const gchar* _tmp9_;
			_tmp9_ = type_name;
			type_name = (const gchar*) (((gchar*) _tmp9_) + 9);
		}
		_tmp10_ = type_name;
		_tmp11_ = g_str_has_suffix (_tmp10_, "Extension");
		if (_tmp11_) {
			gchar* type_no_suffix = NULL;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp12_ = type_name;
			_tmp13_ = type_name;
			_tmp14_ = strlen (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = string_slice (_tmp12_, (glong) 0, (glong) (_tmp15_ - 9));
			type_no_suffix = (gchar*) _tmp16_;
			_tmp17_ = type_no_suffix;
			type_name = _tmp17_;
			_g_free0 (type_no_suffix);
		}
		_tmp18_ = type_name;
		_tmp19_ = self->priv->disabled_extensions;
		_tmp19__length1 = self->priv->disabled_extensions_length1;
		enabled = !_vala_string_array_contains (_tmp19_, _tmp19__length1, _tmp18_);
		_tmp20_ = enabled;
		if (!_tmp20_) {
			const gchar* _tmp21_;
			_tmp21_ = type_name;
			g_message ("extension-collection.vala:115: Skipping %s (disabled)", _tmp21_);
		}
		_tmp23_ = enabled;
		if (_tmp23_) {
			ZeitgeistExtensionLoader* _tmp24_;
			ZeitgeistEngine* _tmp25_;
			ZeitgeistExtension* _tmp26_;
			_tmp24_ = loader;
			_tmp25_ = self->priv->_engine;
			_tmp26_ = zeitgeist_extension_loader_create_instance (_tmp24_, _tmp25_);
			_g_object_unref0 (_tmp22_);
			_tmp22_ = _tmp26_;
		} else {
			_g_object_unref0 (_tmp22_);
			_tmp22_ = NULL;
		}
		_tmp27_ = _g_object_ref0 (_tmp22_);
		e = _tmp27_;
		_tmp28_ = loader;
		g_type_module_unuse ((GTypeModule*) _tmp28_);
		result = e;
		_g_object_unref0 (_tmp22_);
		return result;
	}
	result = NULL;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** zeitgeist_extension_collection_get_extension_names (ZeitgeistExtensionCollection* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_result_ = _tmp0_;
	_result__length1 = 0;
	__result__size_ = _result__length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				GPtrArray* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				const gchar* ext_name = NULL;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gconstpointer _tmp9_;
				GType _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->extensions;
				_tmp5_ = g_ptr_array_get_length (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->extensions;
				_tmp8_ = i;
				_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
				_tmp10_ = G_TYPE_FROM_INSTANCE ((GObject*) ((ZeitgeistExtension*) _tmp9_));
				_tmp11_ = g_type_name (_tmp10_);
				ext_name = _tmp11_;
				_tmp12_ = ext_name;
				_tmp13_ = g_str_has_prefix (_tmp12_, "Zeitgeist");
				if (_tmp13_) {
					gchar** _tmp14_;
					gint _tmp14__length1;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp14_ = _result_;
					_tmp14__length1 = _result__length1;
					_tmp15_ = ext_name;
					_tmp16_ = string_substring (_tmp15_, (glong) 9, (glong) -1);
					_vala_array_add1 (&_result_, &_result__length1, &__result__size_, _tmp16_);
				} else {
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp17_ = _result_;
					_tmp17__length1 = _result__length1;
					_tmp18_ = ext_name;
					_tmp19_ = g_strdup (_tmp18_);
					_vala_array_add2 (&_result_, &_result__length1, &__result__size_, _tmp19_);
				}
			}
		}
	}
	_tmp20_ = _result_;
	_tmp20__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}


void zeitgeist_extension_collection_call_pre_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender) {
	gint num_events = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp14_;
	GPtrArray* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = events;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	num_events = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				GPtrArray* _tmp9_;
				gint _tmp10_;
				gconstpointer _tmp11_;
				GPtrArray* _tmp12_;
				const char* _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->extensions;
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = self->priv->extensions;
				_tmp10_ = i;
				_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
				_tmp12_ = events;
				_tmp13_ = sender;
				zeitgeist_extension_pre_insert_events ((ZeitgeistExtension*) _tmp11_, _tmp12_, _tmp13_);
			}
		}
	}
	_tmp14_ = num_events;
	_tmp15_ = events;
	_tmp16_ = g_ptr_array_get_length (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp14_ == _tmp17_, "num_events == events.length");
}


void zeitgeist_extension_collection_call_post_insert_events (ZeitgeistExtensionCollection* self, GPtrArray* events, const char* sender) {
	gint num_events = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp14_;
	GPtrArray* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = events;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	num_events = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				GPtrArray* _tmp9_;
				gint _tmp10_;
				gconstpointer _tmp11_;
				GPtrArray* _tmp12_;
				const char* _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->extensions;
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = self->priv->extensions;
				_tmp10_ = i;
				_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
				_tmp12_ = events;
				_tmp13_ = sender;
				zeitgeist_extension_post_insert_events ((ZeitgeistExtension*) _tmp11_, _tmp12_, _tmp13_);
			}
		}
	}
	_tmp14_ = num_events;
	_tmp15_ = events;
	_tmp16_ = g_ptr_array_get_length (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_assert (_tmp14_ == _tmp17_, "num_events == events.length");
}


guint32* zeitgeist_extension_collection_call_pre_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender, int* result_length1) {
	guint32* result = NULL;
	guint32* _tmp15_;
	gint _tmp15__length1;
	guint32* _tmp16_;
	gint _tmp16__length1;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				guint32* filtered_ids = NULL;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				guint32* _tmp9_;
				gint _tmp9__length1;
				const char* _tmp10_;
				gint _tmp11_;
				guint32* _tmp12_;
				gint filtered_ids_length1;
				gint _filtered_ids_size_;
				guint32* _tmp13_;
				gint _tmp13__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->extensions;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->extensions;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = event_ids;
				_tmp9__length1 = event_ids_length1;
				_tmp10_ = sender;
				_tmp12_ = zeitgeist_extension_pre_delete_events ((ZeitgeistExtension*) _tmp8_, _tmp9_, _tmp9__length1, _tmp10_, &_tmp11_);
				filtered_ids = _tmp12_;
				filtered_ids_length1 = _tmp11_;
				_filtered_ids_size_ = filtered_ids_length1;
				_tmp13_ = filtered_ids;
				_tmp13__length1 = filtered_ids_length1;
				if (_tmp13_ != NULL) {
					guint32* _tmp14_;
					gint _tmp14__length1;
					_tmp14_ = filtered_ids;
					_tmp14__length1 = filtered_ids_length1;
					event_ids = _tmp14_;
					event_ids_length1 = _tmp14__length1;
				}
				filtered_ids = (g_free (filtered_ids), NULL);
			}
		}
	}
	_tmp15_ = event_ids;
	_tmp15__length1 = event_ids_length1;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp15__length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


void zeitgeist_extension_collection_call_post_delete_events (ZeitgeistExtensionCollection* self, guint32* event_ids, int event_ids_length1, const char* sender) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GPtrArray* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				guint32* _tmp9_;
				gint _tmp9__length1;
				const char* _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->extensions;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->extensions;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = event_ids;
				_tmp9__length1 = event_ids_length1;
				_tmp10_ = sender;
				zeitgeist_extension_post_delete_events ((ZeitgeistExtension*) _tmp8_, _tmp9_, _tmp9__length1, _tmp10_);
			}
		}
	}
}


ZeitgeistEngine* zeitgeist_extension_collection_get_engine (ZeitgeistExtensionCollection* self) {
	ZeitgeistEngine* result;
	ZeitgeistEngine* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_engine;
	result = _tmp0_;
	return result;
}


static void zeitgeist_extension_collection_set_engine (ZeitgeistExtensionCollection* self, ZeitgeistEngine* value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_extension_collection_get_engine (self) != value) {
		ZeitgeistEngine* _tmp0_;
		_tmp0_ = value;
		self->priv->_engine = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_extension_collection_properties[ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY]);
	}
}


static void zeitgeist_extension_collection_class_init (ZeitgeistExtensionCollectionClass * klass) {
	zeitgeist_extension_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistExtensionCollectionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_extension_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_extension_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_extension_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY, zeitgeist_extension_collection_properties[ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY] = g_param_spec_object ("engine", "engine", "engine", ZEITGEIST_TYPE_ENGINE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void zeitgeist_extension_collection_instance_init (ZeitgeistExtensionCollection * self) {
	gchar** _tmp0_;
	self->priv = ZEITGEIST_EXTENSION_COLLECTION_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->disabled_extensions = _tmp0_;
	self->priv->disabled_extensions_length1 = 0;
	self->priv->_disabled_extensions_size_ = self->priv->disabled_extensions_length1;
}


static void zeitgeist_extension_collection_finalize (GObject * obj) {
	ZeitgeistExtensionCollection * self;
	GPtrArray* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection);
	_tmp0_ = self->priv->extensions;
	g_ptr_array_foreach (_tmp0_, __zeitgeist_extension_collection___lambda4__gfunc, self);
	_g_ptr_array_unref0 (self->priv->extensions);
	self->priv->disabled_extensions = (_vala_array_free (self->priv->disabled_extensions, self->priv->disabled_extensions_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (zeitgeist_extension_collection_parent_class)->finalize (obj);
}


GType zeitgeist_extension_collection_get_type (void) {
	static volatile gsize zeitgeist_extension_collection_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_extension_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistExtensionCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_extension_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistExtensionCollection), 0, (GInstanceInitFunc) zeitgeist_extension_collection_instance_init, NULL };
		GType zeitgeist_extension_collection_type_id;
		zeitgeist_extension_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistExtensionCollection", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_extension_collection_type_id__volatile, zeitgeist_extension_collection_type_id);
	}
	return zeitgeist_extension_collection_type_id__volatile;
}


static void _vala_zeitgeist_extension_collection_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistExtensionCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY:
		g_value_set_object (value, zeitgeist_extension_collection_get_engine (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_extension_collection_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistExtensionCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EXTENSION_COLLECTION, ZeitgeistExtensionCollection);
	switch (property_id) {
		case ZEITGEIST_EXTENSION_COLLECTION_ENGINE_PROPERTY:
		zeitgeist_extension_collection_set_engine (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



